# -*- coding: utf-8 -*-
from django import template

register = template.Library()

STAFF_URL_TEMPLATE = 'https://staff.yandex-team.ru/%s'
STAFF_LINK_TEMPLATE = '<a class="yastaff" href="%s" target="blank">%s</a>'


def staff_profile_url(username):
    return STAFF_URL_TEMPLATE % username


def format_staff_link(username):
    return STAFF_LINK_TEMPLATE % (
        staff_profile_url(username),
        '@%s' % username,
    )


class StaffLinkNode(template.Node):
    """Собирает ссылку на staff для просмотра информации о пользователе"""

    def __init__(self, user):
        self.user = template.Variable(user)

    def render(self, context):
        try:
            username = self.user.resolve(context).username
            return format_staff_link(username)
        except template.VariableDoesNotExist:
            return ''


@register.tag
def staff_link(parser, token):
    try:
        tag_name, user = token.split_contents()
    except ValueError:
        raise template.TemplateSyntaxError('Wanna user only')

    return StaffLinkNode(user)
