# -*- coding: utf-8 -*-
from django.conf.urls import patterns, url, include

from django.views.decorators.csrf import (
    csrf_exempt,
    ensure_csrf_cookie,
)
from django.views.generic import RedirectView

from django_yauth.decorators import yalogin_required

from . import views


urlpatterns = patterns(
    '',
    url(r'^$', RedirectView.as_view(url='/grants/reference/')),

    url(r'^reference/$', ensure_csrf_cookie(yalogin_required(views.reference)), name='reference'),

    url(r'^issue/$', ensure_csrf_cookie(yalogin_required(views.IssueListView.as_view())), name='issues'),
    url(r'^issue/(?P<pk>\d+)/$', ensure_csrf_cookie(yalogin_required(views.IssueDetailView.as_view())), name='issue'),
    url(r'^issue/edit/$', ensure_csrf_cookie(yalogin_required(views.EditIssueView.as_view())), name='issue-edit'),
    url(r'^issue/clone/$', ensure_csrf_cookie(yalogin_required(views.CloneIssueView.as_view())), name='issue-clone'),
    url(r'^issue/review/$', yalogin_required(views.issue_review), name='issue-review'),
    url(r'^issue/submit/$', yalogin_required(views.issue_submit), name='issue-submit'),

    url(r'^consumer/$', ensure_csrf_cookie(yalogin_required(views.consumer_list)), name='consumers'),
    url(r'^consumer/suggest/$', yalogin_required(views.consumer_suggest), name='consumer-suggest'),
    url(r'^consumer/search/$', yalogin_required(views.consumer_search), name='consumer-search'),

    url(r'^network/suggest/$', yalogin_required(views.network_suggest), name='network-suggest'),

    url(r'^grant/$', yalogin_required(views.grant_create), name='grant'),
    url(r'^export/$', yalogin_required(views.ExportView.as_view()), name='export'),
    url(r'^client/$', yalogin_required(views.ClientView.as_view()), name='client'),

    # Вебхук Кондуктора на выкладку пакетов с грантами в stable
    url(r'^notify/$', csrf_exempt(views.notify_creators), name='notify-creators'),

    # Non-REST urls
    url(r'^get_grants_list/$', ensure_csrf_cookie(yalogin_required(views.get_grants_list))),

    url(r'^network_validation/$', yalogin_required(views.network_validation)),
    url(r'^operations/$', yalogin_required(views.operations)),

    url(r'^comments/', include('django.contrib.comments.urls')),
)
