# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging
from django.http import QueryDict

from django.views.generic import View
from passport_grants_configurator.apps.core.models import (
    Client,
    Issue,
)

from ..forms import ClientForm
from ..utils import (
    format_form_errors,
    json_response,
)

logger = logging.getLogger(__name__)


class ClientView(View):

    http_method_names = ['post', 'delete']
    form_class = ClientForm
    form = None

    @json_response
    def post(self, request):
        self.form = self.form_class(request.POST)
        if not self.form.is_valid():
            client = self.form.cleaned_data.get('existing_client')
            if client:
                client_issue = Issue.objects.filter(clients__in=[client]).exclude(status__in=['R'])
                client_editable = client_issue.count() == 0
                return {
                    'success': False,
                    'client_id': client.client_id,
                    'name': client.name,
                    'client_pk': client.id,
                    'client_editable': client_editable,
                }
            return {'success': False, 'errors': format_form_errors(self.form.errors)}

        new_client = self.form.save()
        return {'success': True, 'client_pk': new_client.id}

    @json_response
    def delete(self, request):
        params = QueryDict(request.body)
        try:
            Client.objects.get(id=params.get('client_pk')).delete()
        finally:
            return {'success': True}
