# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging
import ujson

from django.conf import settings
from django.views.generic import View
from django.shortcuts import render_to_response

from ..exceptions import ExportError
from ..export_utils import get_exporter
from ..utils import json_response

logger = logging.getLogger(__name__)
EXPORT_STOPPED_MESSAGE = u'Выгрузка остановлена из-за следующих ошибок:'


class ExportView(View):

    http_method_names = ['get', 'post']
    template_name = 'export.html'

    def get(self, request):
        """Отладочный вызов для замера скорости и правильности сборки грантов"""
        project_name = request.GET.get('project_name')
        exporter = get_exporter(
            project_name,
            user=request.user,
        )
        diff = exporter.simulate()
        return render_to_response(self.template_name, dictionary=dict(diff=diff))

    @json_response
    def post(self, request):
        project_name = request.POST.get('project_name')
        force_update = ujson.loads(request.POST.get('force_update', 'false'))
        try:
            exporter = get_exporter(
                project_name,
                user=request.user,
            )
            if settings.SIMULATE_EXPORT_GRANTS:
                diff_result = exporter.simulate(force_update=force_update)
                diff_result.update(
                    success=True,
                    project_name=project_name,
                )
                if diff_result.get('manual_resolve'):
                    diff_result['manual_resolve'].insert(0, EXPORT_STOPPED_MESSAGE)
                return diff_result

            exported = exporter.export(force_update=force_update)
            result = dict(
                success=True,
                diff=exported['diff'],
                warnings=exported['warnings'],
                manual_resolve=exported['manual_resolve'],
                project_name=project_name,
            )

            if exported.get('manual_resolve'):
                result['manual_resolve'].insert(0, EXPORT_STOPPED_MESSAGE)
            return result

        except ExportError as e:
            return {'success': False, 'errors': [e.message]}
