# -*- coding: utf-8 -*
from __future__ import unicode_literals

from django.contrib import admin
from django.contrib.auth.models import Group, Permission
from django import forms
from django.utils import six


def permission_unicode(self):
    return u'%s | %s' % (
        six.text_type(self.content_type),
        six.text_type(self.name),
    )

Permission.__unicode__ = permission_unicode


class PermissionForm(forms.ModelForm):
    name = forms.CharField(max_length=255)
    codename = forms.CharField(max_length=255)

    class Meta:
        model = Permission


class PermissionAdmin(admin.ModelAdmin):
    form = PermissionForm


class GroupAdmin(admin.ModelAdmin):
    search_fields = ('name',)
    ordering = ('name',)
    filter_vertical = ('permissions',)

    def formfield_for_manytomany(self, db_field, request=None, **kwargs):
        if db_field.name == 'permissions':
            qs = kwargs.get('queryset', db_field.rel.to.objects)
            # Avoid a major performance hit resolving permission names which
            # triggers a content_type load:
            kwargs['queryset'] = qs.select_related('content_type')
        return super(GroupAdmin, self).formfield_for_manytomany(
            db_field, request=request, **kwargs)


admin.site.register(Permission, PermissionAdmin)
admin.site.unregister(Group)
admin.site.register(Group, GroupAdmin)
