# -*- coding: utf-8 -*-
import datetime

from django.contrib.auth.models import User, Group, Permission
from django.db import models
from django.conf import settings


class Timestamp(models.Model):
    time = models.DateTimeField()
    name = models.CharField(max_length=32)

    @classmethod
    def last_change(cls):
        return cls.objects.get(name='last_change')

    @classmethod
    def last_export(cls):
        return cls.objects.get(name='last_export')

    @classmethod
    def there_are_unexported_changes(cls):
        return Timestamp.last_change().time > Timestamp.last_export().time


def push_roles(sender, instance, **kwargs):
    if sender not in (User, Group, Permission):
        return
    last_change = Timestamp.objects.get(name='last_change')
    last_change.time = datetime.datetime.now()
    last_change.save()


def update_permission(sender, **kwargs):
    if sender != Permission:
        return
    sender._meta.get_field('name').max_length = settings.PERMISSION_SIZE_NAME
    sender._meta.get_field('name').validators[0].limit_value = settings.PERMISSION_SIZE_NAME
    sender._meta.get_field('codename').max_length = settings.PERMISSION_SIZE_NAME
    sender._meta.get_field('codename').validators[0].limit_value = settings.PERMISSION_SIZE_NAME


models.signals.post_save.connect(push_roles)
models.signals.pre_init.connect(update_permission)
