(function(){

    // Подготавливаемся к работе с CSRF-защитой django
    // https://docs.djangoproject.com/en/1.5/ref/contrib/csrf/#ajax
    var getCookie = function (name) {
        var cookieValue = null;
        if (document.cookie && document.cookie != '') {
            var cookies = document.cookie.split(';');
            for (var i = 0; i < cookies.length; i++) {
                var cookie = $.trim(cookies[i]);
                // Does this cookie string begin with the name we want?
                if (cookie.substring(0, name.length + 1) == (name + '=')) {
                    cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                    break;
                }
            }
        }
        return cookieValue;
    };
    var csrftoken = getCookie('csrftoken');

    var csrfSafeMethod = function (method) {
        // these HTTP methods do not require CSRF protection
        return (/^(GET|HEAD|OPTIONS|TRACE)$/.test(method));
    };
    var sameOrigin = function (url) {
        // test that a given url is a same-origin URL
        // url could be relative or scheme relative or absolute
        var host = document.location.host; // host + port
        var protocol = document.location.protocol;
        var sr_origin = '//' + host;
        var origin = protocol + sr_origin;
        // Allow absolute or scheme relative URLs to same origin
        return (url == origin || url.slice(0, origin.length + 1) == origin + '/') ||
            (url == sr_origin || url.slice(0, sr_origin.length + 1) == sr_origin + '/') ||
            // or any other URL that isn't scheme relative or absolute i.e relative.
            !(/^(\/\/|http:|https:).*/.test(url));
    };
    $.ajaxSetup({
        beforeSend: function(xhr, settings) {
            if (!csrfSafeMethod(settings.type) && sameOrigin(settings.url)) {
                // Send the token to same-origin, relative URLs only.
                // Send the token only if the method warrants CSRF protection
                // Using the CSRFToken value acquired earlier
                xhr.setRequestHeader("X-CSRFToken", csrftoken);
            }
        }
    });
    // ========

    // Эта функция используется на страницах operations & issue как window.request()
    window.request = function (url, data, handler, $indicator, method, $errors) {
        var indicator = $indicator[0];
        if (indicator.loading) return;
        indicator.loading = true;
        $.ajax({
            url: url,
            data: data,
            type: method,
            dataType: "json",
            success: function (response) {
                indicator.loading = false;
                $indicator.html('');
                if (!response.success) {
                    alert('Во время запроса возникли ошибки:\n' + response.errors.join("\n"));
                    $('.disabled').removeClass('disabled');
                };
                if (response.success) {
                    handler(response);
                    $indicator.html('<i class="icon icon-ok"></i>');
                };
            },
            error: function (xhr, status) {
                indicator.loading = false;
                var text = xhr;
                if (typeof(xhr) === 'object') {
                    text = xhr['statusText'];
                }
                var message = '<span class="alert">Ошибка: ' + status + ' ' + text + '</span>';
                $errors.html(message);
            },
            timeout: 1800000 // 30 минут в соответствии с настройками NGINX
        });

        $indicator.html('<i class="icon icon-refresh" title="Подождите"></i>');
    };

    window.projects = ['passport', 'social', 'blackbox', 'blackbox_by_client', 'yasms', 'historydb', 'oauth', 'meltingpot', 'takeout', 'tvm-api'];

    window.operations = {
        init: function() {
            this.$create_grant_form = $('form#create_grant_form');
            this.$create_grant_display = $('#create_grant_display');

            // Включаем автокомплит для всех известных грантов
            var $id_grant_name = this.$create_grant_form.find('#id_grant_name');
            $id_grant_name.attr('list', 'grant_names');

            this.indicators = {};
            this.buttons = {};
            this.errors = {};
            // Найдем все кнопки и индикаторы на странице
            $.each(window.projects, function (index, project_name) {
                window.operations.indicators[project_name] = $('#' + project_name + '-indicator');
                window.operations.errors[project_name] = $('#' + project_name + '-errors');
                window.operations.buttons[project_name] = $('#' + project_name + '-export');
            });

            // Подготовим обработчики кликов на кнопки выгрузки
            $('.export-button').each(function (index, el) {
                var $el = $(el);
                $el.click(function(event){
                    event.preventDefault();
                    event.stopPropagation();

                    var name = $el.data('name');
                    var forced = $("input[name='" + name + "-force']:checkbox");
                    window.operations.exportGrants(name, forced.is(":checked"));
                });
            });
        },

        // Возвращает jquery-объект для индикатора выгрузки грантов этого проекта
        getIndicator: function (project_name) {
            return this.indicators[project_name];
        },
        getErrors: function (project_name) {
            return this.errors[project_name];
        },

        disableOnRequest: function (project_name) {
            this.buttons[project_name].addClass('disabled');
        },

        exportGrants: function(project_name, forced) {
            forced = forced || false;
            request(
                '/grants/export/',
                {
                    'project_name': project_name,
                    'force_update': forced
                },
                window.operations.export_callback,
                window.operations.getIndicator(project_name),
                'POST',
                window.operations.getErrors(project_name)
            );
            this.disableOnRequest(project_name);
        },

        createGrant: function() {
            request(
                '/grants/grant/',
                window.operations.$create_grant_form.serialize(),
                window.operations.createGrant_callback,
                window.operations.$create_grant_display,
                'POST'
            )
        },

        createGrant_callback: function (response) {
            if (response.success) {
                window.operations.$create_grant_display.html('Грант успешно добавлен');
            };
            setTimeout(function() {
                if (window.operations.$create_grant_display.html() == 'Грант успешно добавлен') {
                    window.operations.$create_grant_display.html('');
                };
            }, 10000);
        },

        format_list: function (items) {
            return '<ul>' + items.map(function (item) { return '<li>' + item + '</li> ' }).join('')  + '</ul>';
        },

        export_callback: function (response) {
            var warnings = window.operations.format_list(response.warnings);
            var manual_resolve = window.operations.format_list(response.manual_resolve);
            if (response.diff) {
                $('#' + response.project_name + '-diff > pre').text(response.diff);
                $('#' + response.project_name + '-diff').collapse('show');
            };
            $('#' + response.project_name + '-manual_resolve').html(manual_resolve);
            $('#' + response.project_name + '-warnings').html(warnings);
            $('.btn.disabled').removeClass('disabled');
        }
    };

    window.operations.init();

    window.redirect_to_issue_list = function () {
        window.location = '/grants/issue/';
    };


    var $network_list = $('#network_list');

    var filter = function (area, key, prefix) {
        prefix = prefix || '';
        $('.' + prefix + 'founded').removeClass(prefix + 'founded');
        if (key== '') {
            $(area).removeClass(prefix + 'filter');
            return;
        } else {
            $(area).addClass(prefix + 'filter');
        }
        var $founded = $(area).find('[data-' + prefix + 'id]').filter(function() {
            return this.dataset[prefix + 'id'].toLowerCase().indexOf(key.toLowerCase())>=0
        }).addClass(prefix + 'founded');
        $founded.parentsUntil(area).addClass(prefix + 'founded');
    };

    angular.module('grantushka.indeterminate', [])
        .directive('ngIndeterminate', function() {
        return {
            link: function(scope, elem, attrs) {
                scope.$watch(attrs.ngIndeterminate, function(newVal) {
                    elem[0].indeterminate = !!newVal;
                });
            }
        };
    });

    angular.module('grantushka.threeclick', [])
        .directive('gThreeClick', function () {
        return {
            scope: {
                model: '=gThreeClick'
            },
            link: function(scope, elem) {
                var prevent = function(event) {
                    event.preventDefault()
                };
                elem.click(function() {
                    if (
                        (scope.model.indeterminate || scope.model.expiration) &&
                        scope.model.active_new &&
                        !scope.model.indeterminate_new &&
                        !scope.model.expiration_new
                    ) {
                        scope.model.indeterminate_new = scope.model.indeterminate;
                        scope.model.expiration_new = scope.model.expiration;
                        scope.model.active_new = scope.model.active;
                    } else if (scope.model.expiration_new || scope.model.indeterminate_new) {
                        scope.model.expiration_new = null;
                        scope.model.indeterminate_new = false;
                        scope.model.active_new = true;
                    } else if (!scope.model.active_new) {
                        scope.model.expiration_new = null;
                        scope.model.indeterminate_new = false;
                        scope.model.active_new = false;
                    }
                    scope.$apply()
                })
            }
        }
    });


    var App = angular.module('grantushka', ['grantushka.indeterminate', 'grantushka.threeclick', 'ui.bootstrap']);


    App.directive('ngClickSelect', function () {
        return {
            restrict: 'AC',
            link: function (scope, element, attrs) {
                element.bind('click', function () {
                    element.select();
                });
            }
        };
    });


    App.controller("ConsumersCtrl", ['$scope', '$http', '$timeout', function ($scope, $http, $timeout) {
        var search_timeout = null;

        $scope.range = function(kwargs) {
            var start = kwargs.start || 0;
            var stop = kwargs.stop || 1;
            return Array.apply(null, Array(stop)).map(function (element, i) {return start + i});
        };

        $scope.networks_to_string = function (networks) {
            return _.pluck(networks, 'string').join('\n');
        };

        $scope.grants_to_string = function (grants) {
            return _.map(
                grants,
                function (grant) {
                    // Если грант содержит только одно действие "*" - запишем только его имя @dyor
                    if (grant.actions.length == 1 && grant.actions[0].name == '*') {
                        return grant.name;
                    }

                    // Иначе вернем <имя_гранта>: <действие1> <действие2>
                    return grant.name + ": " + _.pluck(grant.actions, 'name').join(' ');
                }
            ).join('\n');
        };

        //TODO: Эти массивы данных нужно получать через API
        $scope.namespace = NAMESPACE_ID;
        $scope.namespaces = NAMESPACES;
        $scope.environments = ENVIRONMENTS;
        $scope.env_groups = ENV_GROUPS;

        $scope.active_environments = [];
        $scope.environments.forEach(function(e) {
            $scope.active_environments[e.id] = true;
        });
        $scope.env_names = $scope.environments.map(function(e) {return e.name});

        $scope.page = 1;
        $scope.pages = 1;
        $scope.keyword = '';

        $scope.redirect = function(path) {
            window.location.href = path;
        };

        //TODO: Вынести
        $scope.search = function() {
            if (search_timeout) {$timeout.cancel(search_timeout)};
            $scope.consumers=[];

            var get_params = function() {
                return {
                    environments: $scope.active_environments.map(
                        function(e, i) {return e?i: false}
                    ).filter(
                        function(_i) {return _i}
                    ),
                    namespace: $scope.namespace,
                    keyword: $scope.keyword,
                    page: $scope.page
                };
            };

            search_timeout = $timeout(function() {
                var params = get_params();
                if (!params.environments.length) {return};
                $scope.processing_query = true;
                $http({
                    url: '/grants/consumer/search/',
                    method: 'GET',
                    params: params
                }).success(function(data, status, headers, config){
                    if (!angular.equals(config.params, get_params())) {
                        return
                    };
                    $scope.consumers = data.consumer_grants;
                    $scope.pages = data.pages;
                    $scope.processing_query = false;
                }).error(function(data, status, headers, config){
                    $scope.consumers = [];
                    $scope.pages = [];
                    $scope.processing_query = false;
                });
            }, 500)
        };

        $scope.search()
    }]);


    App.controller("CreateIssueCtrl", ['$scope', '$http', function ($scope, $http) {
        $scope.create = 'C';
        $scope.clone = 'CC';
        $scope.modify = 'M';
        $scope.set_expiration = 'E';
        $scope.emails = [];

        $scope.consumer_grants = {};

        $scope.namespace_consumers = NAMESPACE_CONSUMERS;
        $scope.editable_namespaces = EDITABLE_NAMESPACES;
        angular.extend($scope, ISSUE);
        $scope.consumer_grants.clients = ISSUE.clients;

        $scope.namespace = $scope.namespace_consumers.filter(function(n){
            return n.id == $scope.namespace;
        })[0]  || $scope.namespace_consumers[0];

        var today = new Date();
        $scope.expiration_date = ('0' + today.getDate()).slice(-2) + '.' + ('0' + (today.getMonth() + 2)).slice(-2) + '.' + today.getFullYear();

        Object.defineProperty($scope, 'environments', {
            get: function() {
                return $scope.namespace.environments;
            }
        });

        Object.defineProperty($scope, 'active_environments_id', {
            get: function() {
                return $scope.environments
                    .filter(function(e) {return e.active})
                    .map(function(e) {return e.id});
            },
            set: function(id_array) {
                $scope.environments.forEach(function(e) {
                    e.active = (id_array.indexOf(e.id) >= 0);
                });
            }
        });

        $scope.namespace_consumers.forEach(function(nc) {nc.environments[0].active = true});
        $scope.active_environments_id = $scope.environments_id;
        $scope.network_error = '';


        $scope.unsynced = function() {
            if ($scope.consumer_grants.grants) {
                return $scope.consumer_grants.grants.some(function(grant) {
                    return grant.actions.some(function(action) {
                        return action.indeterminate_new && !action.expiration
                    });
                }) || $scope.consumer_macroses && $scope.consumer_macroses.some(function(macros) {
                    return macros.indeterminate_new && !macros.expiration;
                });
            } else {
                return false
            }
        };


        $scope.sync = function() {
            if (!$scope.unsynced) {
                return
            };

            var unsynced_objects = [];

            $scope.consumer_grants.grants.forEach(function(grant) {
                grant.actions.forEach(function(action) {
                    if (action.indeterminate_new) {
                        if (!action.expiration) {
                            action.indeterminate_new = false;
                            action.active_new = true;
                        } else {
                            unsynced_objects.push(grant.name + '-' + action.name);
                        };
                    };
                });
            });

            $scope.consumer_grants.macroses.forEach(function(macros) {
                if (macros.indeterminate_new) {
                    if (!action.expiration) {
                        macros.indeterminate_new = false;
                        macros.active_new = true;
                    } else {
                        unsynced_objects.push(macros.name);
                    };
                };
            });

            if (unsynced_objects.length) {
                $scope.showLabel('error',
                    'Временные гранты необходимо синхронизаровать по окружениям вручную.\n' +
                    'Не были синхронизированы объекты: ' + unsynced_objects.join(', ')
                );
            };
        };


        $scope.toggleEnvironment = function() {setTimeout(function() {
            var active_env = $scope.active_environments_id;

            $scope.consumer_grants.grants && $scope.consumer_grants.grants.forEach(function(grant) {
                grant.actions.forEach(function(action) {
                    var action_envs = active_env.map(function(id) {
                        return action.active_by[id];
                    });
                    var action_new_envs = active_env.map(function(id) {
                        return action.active_new_by[id];
                    });

                    action.active = action_envs.every(function(a) {return a}) && active_env.length > 0;
                    action.active_new = action_new_envs.every(function(a) {return a}) && active_env.length > 0;
                    action.indeterminate = action_envs.some(function(a) {return a !== action_envs[0]});
                    action.indeterminate_new = action_new_envs.some(function(a) {return a !== action_new_envs[0]});
                    action.expiration = !!active_env.length && active_env.map(function(id) {
                        return action.expiration_by[id];
                    }).reduce(function(a1, a2) {
                        return a1 == a2 ? a1 : 'в разных окружениях установлены разные сроки';
                    });
                    delete action.expiration_new;
                    action.expiration_new = !!active_env.length && active_env.map(function(id) {
                        return action.expiration_new_by[id];
                    }).reduce(function(a1, a2) {
                        return a1 == a2 ? a1 : 'в разных окружениях установлены разные сроки';
                    });
                });
            });

            if ($scope.consumer_grants.macroses) {
                $scope.consumer_grants.macroses.forEach(function(macros) {
                    var macros_envs = active_env.map(function(id) {
                        return macros.active_by[id];
                    });
                    var macros_new_envs = active_env.map(function(id) {
                        return macros.active_new_by[id];
                    });

                    macros.active = macros_envs.every(function(a) {return a}) && active_env.length > 0;
                    macros.active_new = macros_new_envs.every(function(a) {return a}) && active_env.length > 0;
                    macros.indeterminate = macros_envs.some(function(a) {return a !== macros_envs[0]});
                    macros.indeterminate_new = macros_new_envs.some(function(a) {return a !== macros_envs[0]});
                    macros.expiration = !!active_env.length && active_env.map(function(id) {
                        return macros.expiration_by[id];
                    }).reduce(function(a1, a2) {
                        return a1 == a2 ? a1 : 'в разных окружениях установлены разные сроки';
                    });

                    delete macros.expiration_new;

                    macros.expiration_new = !!active_env.length && active_env.map(function(id) {
                        return macros.expiration_new_by[id];
                    }).reduce(function(a1, a2) {
                        return a1 == a2 ? a1 : 'в разных окружениях установлены разные сроки';
                    });
                });
            };

            if ($scope.consumer_grants.clients) {

                $scope.active_environments_id.forEach(function (active_env_id) {
                    var active_envs = $scope.environments.filter(function (env) {
                        return Number(env.id) === Number(active_env_id);
                    });
                    active_envs.forEach(function (active_env) {
                        if ($scope.consumer_grants.clients[active_env_id] && $scope.type !== $scope.clone) {
                            active_env.client_pk = $scope.consumer_grants.clients[active_env_id].id;
                            active_env.client_id = $scope.consumer_grants.clients[active_env_id].client_id;
                            active_env.client_name = $scope.consumer_grants.clients[active_env_id].name;
                            active_env.client_editable = $scope.consumer_grants.clients[active_env_id].client_editable;
                        } else {
                            active_env.client_pk = null;
                            active_env.client_id = null;
                            active_env.client_name = null;
                            active_env.client_editable = null;
                        }
                    })
                });
            }

            $scope.$apply();
        }, 10)};


        $scope.toggleType = function(type) {
            $scope.type = type;
            $scope.loadConsumer();
            if ($scope.type === $scope.set_expiration) {
                window.setTimeout(function() {
                    $('#expiration').datepicker().on('changeDate', function(args) {
                        $scope.expiration_date = $('#expiration').val();
                        $scope.$apply();
                    });
                }, 100);
            }
        };
        
        $scope.checkEditable = function () {
            if ($scope.editable_namespaces.indexOf($scope.namespace.id) > -1) {
                document.getElementById('not_editable').style.display = 'none';
                document.getElementById('editable').style.display = ''
            } else {
                document.getElementById('not_editable').style.display = '';
                document.getElementById('editable').style.display = 'none'
            }
        };


        $scope.loadConsumer = function() {
            var consumers = $scope.namespace.consumers;
            var name = $scope.consumer_name;

            $scope.checkEditable();

            $scope.consumer_exists = name in consumers;
            if ($scope.consumer_exists) {
                $scope.consumer_description = consumers[name].description;
                if (ISSUE.consumer_name !== $scope.consumer_name) {
                    $scope.consumer_description_new = consumers[name].description
                }
                $scope.consumer = consumers[name].id;
            }

            if ($scope.consumer_exists && $scope.type === $scope.create){
                $scope.consumer_grants = {};
                return
            } else {
                if (
                    !$scope.consumer_exists &&
                    ($scope.type === $scope.modify || $scope.type === $scope.set_expiration)
                ) {
                    $scope.consumer_grants = {};
                    return
                }
            }

            $scope.loading_consumer = true;
            document.cookie = 'namespace=' + $scope.namespace.id + '; path=/';

            if ($scope.type !== $scope.create && $scope.consumer) {
                var params = {
                    issue: $scope.id,
                    consumer: $scope.consumer
                };
            } else {
                var params = {
                    issue: $scope.id,
                    namespace: $scope.namespace.id
                };
            }

            $scope._request_params = angular.copy(params);
            $http({
                url: '/grants/get_grants_list/',
                method: "GET",
                params: params
            }).success(function(data, status, headers, config) {
                if (! data.success) {
                    $scope.showLabel('error', data.errors.join(' '));
                    return;
                }
                if (! angular.equals(config.params, $scope._request_params)) {
                    return;
                }
                var consumer_grants = data.consumer_grants;

                //TODO: Вынести функцию
                var augment_with_change_states = function(model) {
                    Object.defineProperty(model, 'add', {
                        get: function() {
                            if ($scope.type === $scope.set_expiration) {
                                return (model.expiration_new !== model.expiration);
                            } else {
                                return (model.active * 3 + model.indeterminate * 2 - Boolean(model.expiration)) < (model.active_new * 3 + model.indeterminate_new * 2 - Boolean(model.expiration_new));
                            };
                        }
                    });
                    Object.defineProperty(model, 'remove', {
                        get: function() {
                            if ($scope.type === $scope.set_expiration) {
                                return false;
                            } else {
                                //FIXME: Дублирование формулы расчета
                                return (model.active * 3 + model.indeterminate * 2 - Boolean(model.expiration)) > (model.active_new * 3 + model.indeterminate_new * 2 - Boolean(model.expiration_new));
                            };
                        }
                    });
                    Object.defineProperty(model, 'change', {
                        get: function() {
                            if ($scope.type === $scope.set_expiration) {
                                return false;
                            } else {
                                return (Boolean(model.expiration) !== model.indeterminate) &&
                                       (Boolean(model.expiration_new) !== model.indeterminate_new) &&
                                       (model.indeterminate !== model.indeterminate_new);
                            };
                        }
                    });
                };

                // Какое-то полезное действие с полученными грантами потребителя
                consumer_grants.grants.forEach(function(grant) {
                    grant.actions.forEach(function(action) {augment_with_change_states(action)});
                    grant.active = grant.actions.every(function(action) {return action.active});

                    Object.defineProperty(grant, 'active_new', {
                        get: function() {return grant.actions.every(function(action) {return action.active_new})},
                        set: function(value) {
                            if ((grant.indeterminate || grant.expiration) && !grant.active_new && !grant.indeterminate_new) {
                                grant.actions.forEach(function(action) {
                                    action.active_new = action.active;
                                    action.indeterminate_new = action.indeterminate;
                                    action.expiration_new = action.expiration;
                                });
                            } else if (grant.indeterminate_new || grant.expiration_new) {
                                grant.actions.forEach(function(action) {
                                    action.active_new = true;
                                    action.indeterminate_new = false;
                                    action.expiration_new = null;
                                });
                            } else {
                                grant.actions.forEach(function(action) {
                                    action.active_new = value;
                                    action.indeterminate_new = false;
                                    action.expiration_new = null;
                                });
                            };
                        }
                    });
                    Object.defineProperty(grant, 'indeterminate', {
                        get: function() {
                            return grant.actions.some(function(action, i, array) {
                                return action.active != array[0].active;
                            }) || grant.actions.some(function (action) {return action.indeterminate});
                        }
                    });
                    Object.defineProperty(grant, 'indeterminate_new', {
                        get: function() {
                            return grant.actions.some(function(action, i, array) {
                                return action.active_new != array[0].active_new;
                            }) || grant.actions.some(function (action) {return action.indeterminate_new});
                        }
                    });
                    Object.defineProperty(grant, 'expiration', {
                        get: function() {
                            return grant.actions.map(function(action) {
                                return action.expiration;
                            }).reduce(function(e1, e2) {
                                return e1 === e2 ? e1 : 'установлены разные даты истечения действия';
                            });
                        }
                    });
                    Object.defineProperty(grant, 'expiration_new', {
                        get: function() {
                            return grant.actions.map(function(action) {
                                return action.expiration_new;
                            }).reduce(function(e1, e2) {
                                return e1 === e2 ? e1 : 'установлены разные даты истечения действия';
                            });
                        }
                    });
                });

                consumer_grants.macroses.forEach(function(macros){augment_with_change_states(macros)});
                $scope.consumer_grants = consumer_grants;
                $scope.toggleEnvironment();
                $scope.loading_consumer = false;
            }).error(function(data, status, headers, config) {
                $scope.showLabel('error', 'HTTP/' + status + ': ' + data);
                $scope.loading_consumer = false;
            });
        };


        $scope.actionsChanged = function(grant) {
            var removed = grant.actions.some(function(action) {return action.remove});
            var added = grant.actions.some(function(action) {return action.add});
            var changed = grant.actions.some(function(action) {return action.change});
            if ((removed && added) || changed) {
                return 'change';
            } else if (removed) {
                return 'remove';
            } else if (added) {
                return 'add';
            };
            return '';
        };


        $scope.filter = function () {
            filter(document.querySelector('div.container'), $scope.filter_key);
        };


        $scope.addNetwork = function(environment) {
            var network_in_networks = ($scope.consumer_grants.networks[environment.id] || []).filter(function(network) {
                return network.string == environment.network_input;
            });
            if (!environment.network_input) {return};

            if (network_in_networks.length) {
                $scope.showLabel('network_error', 'Сетевой объект "' + environment.network_input + '" уже находится в списке сетей потребителя');
                return;
            };

            $http({
                url: '/grants/network_validation/',
                method: "GET",
                params: {
                    network: environment.network_input,
                    namespace: $scope.namespace.id,
                    environment: environment.id
                }
            }).success(function(data, status, headers, config) {
                if (! data.success) {
                    $scope.showLabel('network_error', data.errors.join('\n'));
                    return;
                };

                if (! data.network_valid) {
                    $scope.showLabel(
                        'network_error',
                        data.string + ': валидация не пройдена. Ошибки: ' + data.errors.join(' ')
                    );
                    return;
                };

                var environment_id = config.params.environment;
                environment.network_input = '';

                if (!$scope.consumer_grants.networks[environment_id]) {
                    $scope.consumer_grants.networks[environment_id] = [];
                };

                $scope.consumer_grants.networks[environment_id].push({
                    active: false,
                    active_new: true,
                    environment: environment_id,
                    id: data.id,
                    string: data.string,
                    'type': data.type
                });
            }).error(function(data, status, headers, config) {
                $scope.showLabel('error', 'HTTP/' + status + ': ' + data);
                $scope.loading_consumer = false;
            });
        };


        $scope.clearNetworks = function(environment) {
            _.each(
                $scope.consumer_grants.networks[environment.id],
                function (network) {
                    network.active_new = false;
                }
            );
        };


        $scope.addClient = function (environment) {
            var client_id_input = environment.client_id_input;
            var client_name_input = environment.client_name_input;

            if (!client_id_input) {
                $scope.showLabel('client_error', 'Client ID: обязательное поле');
                return;
            }

            // Сразу создадим нового клиента
            var data = {
                client_id: client_id_input,
                name: client_name_input,
                environment: environment.id,
                namespace: $scope.namespace.id
            };

            $http({
                url: '/grants/client/',
                method: "POST",
                data: $.param(data, true),
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                    'X-CSRFToken': csrftoken
                }
            }).success(function(data, status, headers, config) {
                if (! data.success) {
                    if (data.client_pk) {
                        environment.client_pk = data['client_pk'];
                        environment.client_id = data['client_id'];
                        environment.client_name = data['name'];
                        environment.client_editable = data['client_editable'];
                        if (!environment.client_editable) {
                            $scope.showLabel('client_error', 'Предупреждение! ' + environment.client_id + ' клиент уже привязан к заявке')
                        }
                    } else {
                        $scope.showLabel('client_error', data.errors.join('\n'));
                    }
                    return;
                }

                environment.client_pk = data['client_pk'];
                environment.client_id = client_id_input;
                environment.client_name = client_name_input;
                environment.client_editable = true;

            }).error(function(data, status, headers, config) {
                $scope.showLabel('error', 'HTTP/' + status + ': ' + data);
                $scope.loading_consumer = false;
            });
        };

        $scope.deleteClient = function(environment) {
            var data = {
                client_pk: environment.client_pk
            };
            $http({
                url: '/grants/client/',
                method: "DELETE",
                data: $.param(data, true),
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                    'X-CSRFToken': csrftoken
                }
            }).success(function(data, status, headers, config) {
                if (! data.success) {
                    $scope.showLabel('client_error', data.errors.join('\n'));
                    return;
                }

                environment.client_pk = null;
                environment.client_id = '';
                environment.client_name = '';

            }).error(function(data, status, headers, config) {
                $scope.showLabel('error', 'HTTP/' + status + ': ' + data);
                $scope.loading_consumer = false;
            });
        };

        $scope.clearClient = function(environment) {
            environment.client_id = null;
            environment.client_pk = null;
            environment.client_name = null;
            environment.client_editable = null;
        };

        $scope.addEmail = function () {
            var len = $scope.emails.length;
            if (! len) {
                $scope.emails.push({'id': 1});
            }
            else {
                var last_id = $scope.emails[len - 1]['id'];
                $scope.emails.push({'id': last_id + 1});
            }
        };

        $scope.deleteEmail = function(email) {
            var ind = $scope.emails.indexOf(email);
            $scope.emails.splice(ind, 1);
        };

        $scope.showLabel = function(field_name, message, timeout) {
            var show_timeout = timeout || 2000;
            $scope[field_name] = message;
            window.setTimeout(function() {
                if ($scope[field_name] === message) {
                    $scope[field_name] = '';
                };
            }, show_timeout);
        };


        $scope.submitIssue = function(draft) {
            var del_networks = [];
            var add_networks = [];
            var clients = [];
            var empty_clients = [];
            var email_addresses = [];

            $.each($scope.consumer_grants.networks, function(environment_id, networks) {
                if ($scope.active_environments_id.indexOf(Number(environment_id)) >= 0) {
                    [].push.apply(del_networks, networks.filter(function(network) {
                        return network.active && !network.active_new;
                    }).map(function(network) {
                        network.environment = environment_id;
                        return network;
                    }));
                    [].push.apply(add_networks, networks.filter(function(network) {
                        return ($scope.type === $scope.clone) ? network.active || network.active_new : !network.active && network.active_new;
                    }).map(function(network) {
                        network.environment = environment_id;
                        return network;
                    }));
                };
            });
            
            if ($scope.namespace.by_client) {
                // Собираем primary keys клиентов
                $scope.active_environments_id.forEach(function(active_env_id) {
                    var active_envs = $scope.environments.filter(function(env) {
                        return Number(env.id) === Number(active_env_id);
                    });
                    if (!active_envs[0].client_pk) {
                        empty_clients.push(active_envs[0].description);
                    }
                    else {
                        clients.push(active_envs[0].client_pk);
                    }
                });
            }
            if (empty_clients.length > 0 && $scope.namespace.client_required) {
                $scope.showLabel('client_error', 'Please add client for ' + empty_clients.join(', '));
                return;
            }

            // Образцовый WTF x__x
            var data = {
                type: $scope.type,
                draft: draft || false,
                id: $scope.id,
                namespace: $scope.namespace.id,
                environments: $scope.active_environments_id,
                comment: $scope.comment,
                add_action: [].concat.apply([], $scope.consumer_grants.grants.map(function(grant) {
                    if ($scope.type === $scope.clone) {
                        return grant.actions.filter(function(action) {return action.add || action.active});
                    }
                    return grant.actions.filter(function(action) {return action.add});
                })).map(function(action) {return action.id}),
                del_action: [].concat.apply([], $scope.consumer_grants.grants.map(function(grant) {
                    return grant.actions.filter(function(action) {return action.remove })
                })).map(function(action) {return action.id}),
                add_macros: $scope.consumer_grants.macroses.filter(function(macros) {
                    if ($scope.type === $scope.clone) {
                        return macros.active || macros.active_new;
                    }
                    return !macros.active && macros.active_new;
                }).map(function(macros) {return macros.id}),
                del_macros: $scope.consumer_grants.macroses.filter(function(macros) {
                    return macros.active && !macros.active_new;
                }).map(function(macros) {return macros.id}),
                'del_networks-TOTAL_FORMS': del_networks.length,
                'del_networks-INITIAL_FORMS': 0,
                'del_networks-MAX_NUM_FORMS': 1000,
                'add_networks-TOTAL_FORMS': add_networks.length,
                'add_networks-INITIAL_FORMS': 0,
                'add_networks-MAX_NUM_FORMS': 1000
            };

            if (clients) {
                data['clients'] = clients
            }

            $scope.emails.forEach(function (email) {
                email_addresses.push(email['address'])
            });

            if ($scope.emails) {
                data['emails'] = email_addresses
            }

            del_networks.forEach(function(network, i) {
                data['del_networks-' + i + '-environment'] = network.environment;
                data['del_networks-' + i + '-network'] = network.id;
            });
            add_networks.forEach(function(network, i) {
                data['add_networks-' + i + '-environment'] = network.environment;
                data['add_networks-' + i + '-network'] = network.id;
            });

            if ($scope.consumer_description != $scope.consumer_description_new) {
                data.consumer_description = $scope.consumer_description_new;
            };

            if ($scope.type === $scope.clone) {
                data.consumer_name = $scope.consumer_name_new || $scope.consumer_name;
                $scope.consumer_name_new = ''
            }

            if ($scope.consumer_name_new) {
                if (!$scope.validate_consumer($scope.consumer_name_new)) {
                    $scope.showLabel('error', 'Ошибка: Запрещенные символы в имени потребителя');
                    return
                }
                data.consumer_name_new = $scope.consumer_name_new;
            };

            if ($scope.type == $scope.modify || $scope.type == $scope.set_expiration) {
                data.consumer = $scope.consumer;
            } else if ($scope.type == $scope.create) {
                if (!$scope.validate_consumer($scope.consumer_name)) {
                    $scope.showLabel('error', 'Ошибка: Запрещенные символы в имени потребителя');
                    return
                }
                data.consumer_name = $scope.consumer_name;
            };
            if ($scope.type == $scope.set_expiration) {
                data.expiration = $scope.expiration_date;
            };

            $scope.sending_form = true;
            $http({
                method: 'POST',
                url: '/grants/issue/submit/',
                data: $.param(data, true),
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                    'X-CSRFToken': csrftoken
                }
            }).success(function(data){
                if (! data.success) {
                    $scope.showLabel('error', data.errors.join('\n'));
                    // Отображаем внизу страницы, поближе к кнопке submit
                    $scope.showLabel('page_down_error', data.errors.join('\n'));
                    $scope.sending_form = false;
                } else {
                    window.location = '/grants/issue/' + data.issue_id;
                };
            });
        };

        $scope.loadConsumer();

        $scope.setExpiration = function(model) {
            if (!$scope.expiration_date) {
                $scope.showLabel('error', 'Установите, пожалуйста, дату истечения срока действия грантов');
                return;
            }
            if (model.expiration_new !== model.expiration) {
                delete model.expiration_new;
                model.expiration_new = model.expiration;
                model.active_new = model.active;
                model.indeterminate_new = model.indeterminate;
            } else {
                Object.defineProperty(model, 'expiration_new', {
                    get: function() {return $scope.expiration_date}
                });
                model.active_new = true;
                model.indeterminate_new = false;
            }
        };


        $scope.setGrantExpiration = function(grant) {
            if (!$scope.expiration_date) {
                $scope.showLabel('error', 'Установите, пожалуйста, дату истечения срока действия грантов');
                return;
            };
            if ($scope.actionsChanged(grant)) { // HERE here might be hell, need to recheck
                grant.actions.forEach(function(action) {
                    if (action.add || action.remove || action.change) {
                        $scope.setExpiration(action);
                    };
                });
            } else {
                grant.actions.forEach($scope.setExpiration);
            };
        };


        $scope.some = function(array, property) {
            return array.some(function(element) {return element[property]});
        };


        $scope.every = function(array, property) {
            return array.every(function(element) {return element[property]});
        };


        $scope.same = function(array, property) {
            return array.map(function(element) {
                return element[property];
            }).reduce(function(first, second) {
                return first === second ? second : null;
            });
        };

        $scope.validate_consumer = function (consumer_name) {
            var result = consumer_name.match(/^[a-zA-Z0-9-_.;/'@,:()]+$/g);
            return Boolean(result)
        };

        $scope.suggestConsumer = function (keyword) {
            return $http.get('/grants/consumer/suggest/', {
                params: {
                    'namespace': $scope.namespace.id,
                    'keyword': keyword
                }
            }).then(function (response) {
                if (! response.data.success) {
                    $scope.showLabel('error', response.data.errors.join(' '));
                    $scope.sending_form = false;
                } else {
                    var suggestions = response.data.suggestions;
                    var previous_group = '';
                    if (response.data.caching_networks) {
                        $scope.showLabel('info', 'Если вы ищете сети, то попробуйте через пару минут', 4000);
                    }
                    suggestions.forEach(function (suggestion) {
                        var suggestion_group = suggestion.group;
                        if (suggestion_group == previous_group) {
                            delete suggestion.group;
                        };
                        previous_group = suggestion_group;
                    });
                    return suggestions;
                };
            });
        };

        $scope.suggestNetwork = function (keyword) {
            if (keyword.length < 3) {
                return
            }
            return $http.get('/grants/network/suggest/', {
                params: {
                    'keyword': keyword
                }
            }).then(function (response) {
                if (response.data.success) {
                    return response.data.suggestions;
                }
            });
        };

        $scope.selectConsumerSuggest = function($item) {
            $scope.consumer_name = $item.name;
            $scope.loadConsumer();
        };
    }
    ]);

})();
