# -*- coding: utf-8 -*-
import os
from collections import defaultdict

import yenv

from . import secrets

SECRET_KEY = secrets.SECRET_KEY

ADMINS = (
    ('grantushka-admin', 'grantushka-admin@yandex-team.ru'),
)

PROJECT_NAME = 'yandex-passport-grants-configurator'
PROJECT_DIR = os.path.abspath(os.path.dirname(os.path.dirname(__file__)))
ENV_TYPE = yenv.type

_current_user = os.environ.get('USER', os.environ.get('LOGNAME', 'root'))

SHORT_PROJECT_NAME = PROJECT_NAME.split('-', 1)[-1]

DEBUG = False
TEMPLATE_DEBUG = DEBUG
GRANTS_MAIL_ENV_NAME = False
ENV_NAME = yenv.type.title()

DB_NAME = SHORT_PROJECT_NAME.replace('-', '_')
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',
        'HOST': 'cnt-dbm-test.passport.yandex.net',
        'NAME': DB_NAME,
        'USER': secrets.DB_USER,
        'PASSWORD': secrets.DB_PASSWORD,
        'TEST_CHARSET': 'UTF8',
    },
}

DATABASE_ROUTERS = [
    'passport_grants_configurator.apps.core.routers.AllowAllRelationsRouter',
    'django_replicated.ReplicationRouter',
]

FORCE_SCRIPT_NAME = ''

TIME_ZONE = 'Europe/Moscow'
LANGUAGE_CODE = 'ru'
_ = lambda s: s

LANGUAGES = (
    ('ru', _('Russian')),
)

USE_I18N = True

MEDIA_ROOT = os.path.join(PROJECT_DIR, 'media')
STATIC_ROOT = os.path.join(PROJECT_DIR, 'static')

MEDIA_URL = '/media/'
STATIC_URL = '/static/'

STATICFILES_DIRS = (
    os.path.join(PROJECT_DIR, 'common_static'),
)

SECURE_PROXY_SSL_HEADER = ('HTTP_X_FORWARDED_PROTOCOL', 'https')

TEMPLATE_LOADERS = [
    'django.template.loaders.filesystem.Loader',
    'django.template.loaders.app_directories.Loader',
]

TEMPLATE_DIRS = [
    os.path.join(PROJECT_DIR, 'templates'),
]

MIDDLEWARE_CLASSES = [
    'passport_grants_configurator.apps.core.middlewares.PingMiddleware',

    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.middleware.locale.LocaleMiddleware',

    'django_replicated.middleware.ReplicationMiddleware',
    'django_yauth.middleware.YandexAuthMiddleware',
]

ROOT_URLCONF = 'passport_grants_configurator.urls'

TEMPLATE_CONTEXT_PROCESSORS = (
    'django.contrib.auth.context_processors.auth',
    'django.contrib.messages.context_processors.messages',
    'django.core.context_processors.request',
    'django.core.context_processors.csrf',
    'django.core.context_processors.media',
    'django.core.context_processors.static',

    'django_yauth.context.yauth',

    'passport_grants_configurator.apps.core.context_processors.settings',
    'passport_grants_configurator.apps.core.context_processors.namespaces',
)

INSTALLED_APPS = [
    'django_yauth',
    'django_template_common',
    'django_replicated',
    'django_extensions',

    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.messages',
    'django.contrib.sessions',
    'django.contrib.staticfiles',
    'django.contrib.contenttypes',
    'django.contrib.sites',
    'django.contrib.comments',

    'south',
    'guardian',

    'passport_grants_configurator.apps.core',
]

AUTHENTICATION_BACKENDS = (
    'django.contrib.auth.backends.ModelBackend',
    'guardian.backends.ObjectPermissionBackend',
)


# === Logging

if _current_user in ('www-data', 'root'):
    LOG_PATH = '/var/log/yandex/passport-grants-configurator/'
else:
    LOG_PATH = ''

LOGGING = {
    'version': 1,
    'formatters': {
        'simple': {
            'format': '%(levelname)s %(message)s',
        },
        'default': {
            'format': '%(asctime)s %(name)s %(levelname)s %(message)s',
        },
        'verbose': {
            'format': '%(asctime)s pid=%(process)s %(name)s %(levelname)s %(module)s %(message)s',
        },
    },
    'handlers': {
        'null': {
            'class': 'logging.NullHandler',
        },
        'default': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': 'default.log',
            'formatter': 'verbose',
        },
        'network': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': 'network.log',
            'formatter': 'default',
        },
        'crontab': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': 'crontab.log',
            'formatter': 'default',
        },
        'export': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': 'export.log',
            'formatter': 'default',
        },
        'django': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': 'django.log',
            'formatter': 'default',
        },
        'requests': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': 'requests.log',
            'formatter': 'default',
        },
        'mail_admins': {
            'level': 'ERROR',
            'class': 'django.utils.log.AdminEmailHandler',
            'filters': [],
        },
    },
    'loggers': {
        'passport_grants_configurator.apps.core.network_apis': {
            'handlers': ['network'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport_grants_configurator.apps.core.network_search_tools': {
            'handlers': ['network'],
            'level': 'DEBUG',
            'propagate': False,
        },

        'passport_grants_configurator.apps.core.management.commands.hourly': {
            'handlers': ['crontab'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport_grants_configurator.apps.core.management.commands.daily': {
            'handlers': ['crontab'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport_grants_configurator.apps.core.management.commands.noon': {
            'handlers': ['crontab'],
            'level': 'DEBUG',
            'propagate': False,
        },

        'passport_grants_configurator.apps.passport_admin_roles_adapter.management.commands.export_roles': {
            'handlers': ['export'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport_grants_configurator.apps.core.export_utils': {
            'handlers': ['export'],
            'level': 'DEBUG',
            'propagate': False,
        },

        'django': {
            'handlers': ['django'],
            'level': 'INFO',
            'propagate': False,
        },
        'django.request': {
            'handlers': ['mail_admins', 'default'],
            'level': 'INFO',
        },
        'nose': {
            'handlers': ['null'],
            'propagate': False,
        },
        # django-replicated
        'replicated': {
            'handlers': ['django'],
            'level': 'INFO',
            'propagate': False,
        },
        # python-requests
        'requests': {
            'handlers': ['requests'],
            'level': 'DEBUG',
            'propagate': False,
        },
        # Логгер для сторонней библиотеки kazoo
        'kazoo.client': {
            'handlers': ['default'],
            'level': 'INFO',
            'propagate': False,
        },
    },
    'root': {
        'handlers': ['default'],
        'level': 'DEBUG',
    },
}

for k, v in LOGGING['handlers'].items():
    if 'filename' in v:
        v['filename'] = os.path.join(LOG_PATH, v['filename'])


# AUTH
from django_yauth.settings import *
from blackbox import XmlBlackbox, FIELD_LOGIN
YAUTH_BLACKBOX_INSTANCE = XmlBlackbox(XmlBlackbox.URLS['intranet']['production'], dbfields=[FIELD_LOGIN])
YAUSER_ADMIN_LOGIN = True  # Deprecated, since django-yauth 3.33 use new constant name YAUTH_USE_NATIVE_USER
YAUTH_USE_NATIVE_USER = True

YAUTH_USE_SITES = False
YAUTH_TYPE = 'intranet'
CREATE_PROFILE_ON_ACCESS = True
CREATE_USER_ON_ACCESS = True
ANONYMOUS_USER_ID = -1

# MAIL
EMAIL_BACKEND = 'django.core.mail.backends.locmem.EmailBackend'
EMAIL_SUBJECT_PREFIX = '[%s] ' % PROJECT_NAME
EMAIL_NOTIFICATION_FROM = 'grantushka-admin@yandex-team.ru'
DATETIME_FORMAT = 'd.m.Y, H:i'

FEEDBACK_EMAIL_ADDRESS = 'grantushka-admin@yandex-team.ru'

_ALLOWED_TLDS = ['ru', 'com']
YANDEX_TEAM_EMAIL_DOMAINS = ['yandex-team.%s' % tld for tld in _ALLOWED_TLDS]
YANDEX_MONEY_EMAIL_DOMAINS = ['yamoney.%s' % tld for tld in _ALLOWED_TLDS]
ALLOWED_NOTIFICATION_EMAIL_DOMAINS = YANDEX_TEAM_EMAIL_DOMAINS + YANDEX_MONEY_EMAIL_DOMAINS
DEFAULT_EMAIL_DOMAIN = 'yandex-team.ru'

# Сюда шлем письма о новых заявках на выдачу грантов
EMAIL_GRANT_ADMINS = ('grantushka-admin@yandex-team.ru',)
# Сюда шлем оповещения о ходе ежедневной симуляции выгрузки
EMAIL_NOTIFICATION_TO = ('grantushka-admin@yandex-team.ru',)
# Урл со страницей выгрузки грантов переопределяется для каждого окружения
EXPORT_GRANTS_URL = ''

SIMULATE_EXPORT_GRANTS = True

SITE_ID = 2

ROBOT_NAME = 'passport-grants-robo'
CVS_USER_NAME = ROBOT_NAME

ALLOWED_HOSTS = ['*']

APP_PATH = '/usr/lib/yandex/passport-grants-configurator/'

CONDUCTOR_API_NO_CACHE = {
    'address': 'https://c.yandex-team.ru/api/',
    'timeout': 60,
    'retry': 2,
}

CONDUCTOR_API = {
    'address': 'https://c.yandex-team.ru/api-cached/',
    'timeout': 60,
    'retry': 2,
}

GOLEM_API = {
    'address': 'http://ro.admin.yandex-team.ru/api/',
    'timeout': 3,
    'retry': 2,
}

RACKTABLES_API = {
    'address': 'https://racktables.yandex.net/export/',
    'timeout': 60,
    'retry': 2,
}

HBF_API = {
    'address': 'http://hbf.yandex.net/',
    'timeout': 5,
    'retry': 2,
}

PUNCHER_API = {
    'address': 'https://puncher.yandex-team.ru/api/',
    'timeout': 5,
    'retry': 2,
}

BITBUCKET_API_DEFAULTS = {
    'api_timeout': 1,
    'api_token': secrets.BITBUCKET_API_TOKEN,
    'committer': {
        'DEBFULLNAME': 'Passport Grants Robot',
        'DEBEMAIL': 'passport-admin@yandex-team.ru',
    },
}

PASSPORT_GIT_API = BITBUCKET_API_DEFAULTS.copy()
PASSPORT_GIT_API.update({
    'project': 'passport',
    'repo': 'ssh://git@bb.yandex-team.ru/tvm/passport-grants.git',
    'working_dir': '/var/lib/yandex/passport-grants-configurator/exports/passport-grants/',
    'commits': 'https://bb.yandex-team.ru/rest/api/1.0/projects/tvm/repos/passport-grants/commits',
})

MELTINGPOT_GIT_API = BITBUCKET_API_DEFAULTS.copy()
MELTINGPOT_GIT_API.update({
    'project': 'meltingpot',
    'repo': 'ssh://git@bb.yandex-team.ru/tvm/meltingpot-grants.git',
    'working_dir': '/var/lib/yandex/passport-grants-configurator/exports/meltingpot/',
    'commits': 'https://bb.yandex-team.ru/rest/api/1.0/projects/tvm/repos/meltingpot-grants/commits',
})

SOCIAL_GIT_API = BITBUCKET_API_DEFAULTS.copy()
SOCIAL_GIT_API.update({
    'project': 'social',
    'repo': 'ssh://git@bb.yandex-team.ru/tvm/social-grants.git',
    'working_dir': '/var/lib/yandex/passport-grants-configurator/exports/social-grants/',
    'commits': 'https://bb.yandex-team.ru/rest/api/1.0/projects/tvm/repos/social-grants/commits',
})

YASMS_GIT_API = BITBUCKET_API_DEFAULTS.copy()
YASMS_GIT_API.update({
    'project': 'yasms',
    'repo': 'ssh://git@bb.yandex-team.ru/tvm/yasms-grants.git',
    'working_dir': '/var/lib/yandex/passport-grants-configurator/exports/yasms-grants/',
    'commits': 'https://bb.yandex-team.ru/rest/api/1.0/projects/tvm/repos/yasms-grants/commits',
})

BLACKBOX_GIT_API = BITBUCKET_API_DEFAULTS.copy()
BLACKBOX_GIT_API.update({
    'project': 'blackbox',
    'repo': 'ssh://git@bb.yandex-team.ru/tvm/blackbox-grants.git',
    'working_dir': '/var/lib/yandex/passport-grants-configurator/exports/blackbox-grants/',
    'commits': 'https://bb.yandex-team.ru/rest/api/1.0/projects/tvm/repos/blackbox-grants/commits',
})
BLACKBOX_BY_CLIENT_GIT_API = BITBUCKET_API_DEFAULTS.copy()
BLACKBOX_BY_CLIENT_GIT_API.update({
    'project': 'blackbox_by_client',
    'repo': 'ssh://git@bb.yandex-team.ru/tvm/blackbox-by-client-grants.git',
    'working_dir': '/var/lib/yandex/passport-grants-configurator/exports/blackbox-by-client-grants/',
    'commits': 'https://bb.yandex-team.ru/rest/api/1.0/projects/tvm/repos/blackbox-by-client-grants/commits',
})

HISTORYDB_GIT_API = BITBUCKET_API_DEFAULTS.copy()
HISTORYDB_GIT_API.update({
    'project': 'historydb',
    'repo': 'ssh://git@bb.yandex-team.ru/tvm/historydb-grants.git',
    'working_dir': '/var/lib/yandex/passport-grants-configurator/exports/historydb-grants/',
    'commits': 'https://bb.yandex-team.ru/rest/api/1.0/projects/tvm/repos/historydb-grants/commits',
})

OAUTH_GIT_API = BITBUCKET_API_DEFAULTS.copy()
OAUTH_GIT_API.update({
    'project': 'oauth',
    'repo': 'ssh://git@bb.yandex-team.ru/tvm/oauth-grants.git',
    'working_dir': '/var/lib/yandex/passport-grants-configurator/exports/oauth-grants/',
    'commits': 'https://bb.yandex-team.ru/rest/api/1.0/projects/tvm/repos/oauth-grants/commits',
})

TAKEOUT_GIT_API = BITBUCKET_API_DEFAULTS.copy()
TAKEOUT_GIT_API.update({
    'project': 'takeout',
    'repo': 'ssh://git@bb.yandex-team.ru/tvm/takeout-grants.git',
    'working_dir': '/var/lib/yandex/passport-grants-configurator/exports/takeout-grants/',
    'commits': 'https://bb.yandex-team.ru/rest/api/1.0/projects/tvm/repos/takeout-grants/commits',
})

TVM_GIT_API = BITBUCKET_API_DEFAULTS.copy()
TVM_GIT_API.update({
    'project': 'tvm-api',
    'repo': 'ssh://git@bb.yandex-team.ru/tvm/tvm-api-grants.git',
    'working_dir': '/var/lib/yandex/passport-grants-configurator/exports/tvm-api-grants/',
    'commits': 'https://bb.yandex-team.ru/rest/api/1.0/projects/tvm/repos/tvm-api-grants/commits',
})

CVS_TIMEOUT = 60

# Доступ к репозиторию сетевых макросов
RACKTABLES_API_CVS = {
    'repo': '%s@cvs.yandex-team.ru:/opt/CVSROOT' % CVS_USER_NAME,
    'working_dir': '/var/lib/yandex/passport-grants-configurator/imports/',
    'path': 'noc/routers/fw',
    'output': 'racktables-routers-fw',
    'timeout': CVS_TIMEOUT,
}


STATICFILES_STORAGE = 'django.contrib.staticfiles.storage.CachedStaticFilesStorage'

CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.locmem.LocMemCache',
    },
}

GRANTS_CHECKER_FILENAME = 'checker.py'

GRANTS_PROJECTS = {
    'passport': {
        'local_name': u'Паспорт',
        'git_api': PASSPORT_GIT_API,
        'namespaces': ['passport'],
        'file_names': {
            ('passport', 'localhost', 'production'): 'grants/consumer_grants.production.json',
            ('passport', 'localhost', 'testing'): 'grants/consumer_grants.testing.json',
            ('passport', 'localhost', 'development'): 'grants/consumer_grants.development.json',
            ('passport', 'intranet', 'production'): 'grants/consumer_grants.intranet.production.json',
            ('passport', 'intranet', 'testing'): 'grants/consumer_grants.intranet.testing.json',
            ('passport', 'intranet', 'development'): 'grants/consumer_grants.intranet.development.json',
            ('passport', 'stress', 'stress'): 'grants/consumer_grants.stress.stress.json',
        },
    },
    'meltingpot': {
        'local_name': u'Большой котел',
        'git_api': MELTINGPOT_GIT_API,
        'namespaces': ['meltingpot'],
        'file_names': {
            ('meltingpot', 'localhost', 'production'): 'grants/consumer_grants.production.json',
            ('meltingpot', 'localhost', 'testing'): 'grants/consumer_grants.testing.json',
            ('meltingpot', 'localhost', 'development'): 'grants/consumer_grants.development.json',
        },
    },
    'social': {
        'local_name': u'Социализм',
        'git_api': SOCIAL_GIT_API,
        'namespaces': ['social api', 'social proxy', 'social broker'],
        'file_names': {
            ('social api', 'localhost', 'production'): 'social_grants/production/social-api2.json',
            ('social api', 'localhost', 'testing'): 'social_grants/testing/social-api2.json',
            ('social api', 'localhost', 'development'): 'social_grants/development/social-api2.json',
            ('social api', 'other', 'production'): 'social_grants/production/social-api2.other.json',
            ('social proxy', 'localhost', 'production'): 'social_grants/production/social-proxy.json',
            ('social proxy', 'localhost', 'testing'): 'social_grants/testing/social-proxy.json',
            ('social proxy', 'localhost', 'development'): 'social_grants/development/social-proxy.json',
            ('social proxy', 'other', 'production'): 'social_grants/production/social-proxy.other.json',
            ('social broker', 'localhost', 'production'): 'social_grants/production/social-broker.json',
            ('social broker', 'localhost', 'testing'): 'social_grants/testing/social-broker.json',
            ('social broker', 'localhost', 'development'): 'social_grants/development/social-broker.json',
            ('social broker', 'other', 'production'): 'social_grants/production/social-broker.other.json',
        },
    },
    'yasms': {
        'local_name': u'ЯСМС',
        'git_api': YASMS_GIT_API,
        'namespaces': ['yasms'],
        'file_names': {
            ('yasms', 'localhost', 'development'): 'grants/yasms_for_passport.development.json',
            ('yasms', 'localhost', 'testing'): 'grants/yasms_for_passport.testing.json',
            ('yasms', 'localhost', 'production'): 'grants/yasms_for_passport.production.json',
            ('yasms', 'localhost', 'rc'): 'grants/yasms_for_passport.rc.json',
            ('yasms', 'stress', 'stress'): 'grants/yasms_for_passport.stress.json',
        },
    },
    'blackbox': {
        'local_name': 'Blackbox',
        'git_api': BLACKBOX_GIT_API,
        'namespaces': ['blackbox'],
        'file_names': {
            ('blackbox', 'localhost', 'production'): 'grants/grants-prod.conf',
            ('blackbox', 'localhost', 'development'): 'grants/grants-dev.conf',
            ('blackbox', 'localhost', 'testing'): 'grants/grants-test.conf',
            ('blackbox', 'stress', 'stress'): 'grants/grants-stress.conf',
            ('blackbox', 'other', 'production'): 'grants/grants-mimino.conf',
            ('blackbox', 'intranet', 'production'): 'grants/grants-yateam.conf',
            ('blackbox', 'intranet', 'testing'): 'grants/grants-yateam-test.conf',
        },
    },
    'blackbox_by_client': {
        'local_name': 'Blackbox by Client',
        'git_api': BLACKBOX_BY_CLIENT_GIT_API,
        'namespaces': ['blackbox_by_client'],
        'file_names': {
            ('blackbox_by_client', 'localhost', 'production'): 'grants/consumer_grants.production.json',
            ('blackbox_by_client', 'localhost', 'development'): 'grants/consumer_grants.development.json',
            ('blackbox_by_client', 'localhost', 'testing'): 'grants/consumer_grants.testing.json',
            ('blackbox_by_client', 'stress', 'stress'): 'grants/consumer_grants.stress.json',
            ('blackbox_by_client', 'other', 'production'): 'grants/consumer_grants.other.json',
            ('blackbox_by_client', 'intranet', 'production'): 'grants/consumer_grants.intranet.json',
            ('blackbox_by_client', 'intranet', 'testing'): 'grants/consumer_grants.intranet.testing.json',
        },
    },
    'historydb': {
        'local_name': 'HistoryDB',
        'git_api': HISTORYDB_GIT_API,
        'namespaces': ['historydb'],
        'file_names': {
            ('historydb', 'localhost', 'production'): 'grants/consumer_grants.production.json',
            ('historydb', 'localhost', 'testing'): 'grants/consumer_grants.testing.json',
            ('historydb', 'localhost', 'development'): 'grants/consumer_grants.development.json',
        },
    },
    'oauth': {
        'local_name': 'OAuth',
        'git_api': OAUTH_GIT_API,
        'namespaces': ['oauth'],
        'file_names': {
            ('oauth', 'localhost', 'production'): 'grants/scope_grants.production.json',
            ('oauth', 'localhost', 'testing'): 'grants/scope_grants.testing.json',
            ('oauth', 'localhost', 'development'): 'grants/scope_grants.development.json',
            ('oauth', 'intranet', 'production'): 'grants/scope_grants.intranet.production.json',
            ('oauth', 'intranet', 'testing'): 'grants/scope_grants.intranet.testing.json',
            ('oauth', 'stress', 'stress'): 'grants/scope_grants.stress.stress.json',
        },
    },
    'takeout': {
        'local_name': 'Takeout',
        'git_api': TAKEOUT_GIT_API,
        'namespaces': ['takeout'],
        'file_names': {
            ('takeout', 'localhost', 'production'): 'grants/consumer_grants.production.json',
            ('takeout', 'localhost', 'testing'): 'grants/consumer_grants.testing.json',
            ('takeout', 'localhost', 'development'): 'grants/consumer_grants.development.json',
        },
    },
    'tvm-api': {
        'local_name': 'TVM Api',
        'git_api': TVM_GIT_API,
        'namespaces': ['tvm-api'],
        'file_names': {
            ('tvm-api', 'localhost', 'production'): 'grants/consumer_grants.production.json',
            ('tvm-api', 'localhost', 'testing'): 'grants/consumer_grants.testing.json',
            ('tvm-api', 'localhost', 'development'): 'grants/consumer_grants.development.json',
            ('tvm-api', 'intranet', 'production'): 'grants/consumer_grants.intranet.production.json',
            ('tvm-api', 'intranet', 'testing'): 'grants/consumer_grants.intranet.testing.json',
        },
    },

}

PROJECTS = dict(GRANTS_PROJECTS.items())

NAMESPACE_ENVIRONMENTS = {
    'passport': (
        ('localhost', 'production'),
        ('localhost', 'testing'),
        ('localhost', 'development'),
        ('intranet', 'production'),
        ('intranet', 'testing'),
        ('intranet', 'development'),
        ('stress', 'stress'),
    ),
    'meltingpot': (
        ('localhost', 'production'),
        ('localhost', 'testing'),
        ('localhost', 'development'),
    ),
    'historydb': (
        ('localhost', 'production'),
        ('localhost', 'testing'),
        ('localhost', 'development'),
    ),
    'social api': (
        ('localhost', 'production'),
        ('localhost', 'testing'),
        ('localhost', 'development'),
        ('other', 'production'),
    ),
    'oauth': (
        ('localhost', 'production'),
        ('localhost', 'testing'),
        ('localhost', 'development'),
        ('intranet', 'production'),
        ('intranet', 'testing'),
        ('stress', 'stress'),
    ),
    'social proxy': (
        ('localhost', 'development'),
        ('localhost', 'production'),
        ('localhost', 'testing'),
        ('other', 'production'),
    ),
    'yasms': (
        ('localhost', 'production'),
        ('localhost', 'rc'),
        ('localhost', 'testing'),
        ('localhost', 'development'),
    ),
    'blackbox': (
        ('localhost', 'production'),
        ('localhost', 'testing'),
        ('localhost', 'development'),
        ('intranet', 'production'),
        ('intranet', 'testing'),
        ('other', 'production'),  # mimino
        ('stress', 'stress'),
    ),
    'social broker': (
        ('localhost', 'production'),
        ('localhost', 'testing'),
        ('localhost', 'development'),
        ('other', 'production'),
    ),
    'takeout': (
        ('localhost', 'production'),
        ('localhost', 'testing'),
        ('localhost', 'development'),
    ),
    'tvm-api': (
        ('localhost', 'production'),
        ('localhost', 'testing'),
        ('localhost', 'development'),
        ('intranet', 'production'),
        ('intranet', 'testing'),
    ),
}

ENVIRONMENT_HUMAN_NAMES = defaultdict(lambda: {
    'localhost': u'Yandex',
    'intranet': u'Yandex-Team',
    'stress': u'Стресс',
    'other': u'Остальные',
})
ENVIRONMENT_HUMAN_NAMES['blackbox']['other'] = u'Mimino'
ENVIRONMENT_HUMAN_NAMES['social api']['other'] = u'Social-testrc.yandex'
ENVIRONMENT_HUMAN_NAMES['social proxy']['other'] = u'Social-testrc.yandex'


SOCKET_RETRY = 3
PYTHON_DATE_FORMAT = '%d.%m.%Y'
DATE_INPUT_FORMATS = (PYTHON_DATE_FORMAT,)
DB_DATE_FORMAT = '%Y-%m-%d %H:%M:%S'
CONSUMER_PAGE_SIZE = 20

DAYS_BEFORE_FIRST_NOTIFICATION = 16
DAYS_BEFORE_SECOND_NOTIFICATION = 5

REDIS_CONFIG = {
    'host': 'localhost',
    'port': 6379,
    'db': 0,
    'password': secrets.REDIS_PASSWORD,  # Этот пароль установлен в пакете yandex-passport-local-redis
}

REDIS_CACHE_ENABLED = True
REDIS_CACHE_TIMEOUT = 70 * 60
REDIS_RETRIES = 3
REDIS_KEY_PREFIX = 'grant'
REDIS_NETWORK_PREFIX = 'net'
REDIS_MACRO_CHILDREN_PREFIX = 'macro_children'
REDIS_C_GROUP_CHILDREN_PREFIX = 'c_group_children'

# TODO: Вообще говоря, все это можно и нужно выгружать со staff
# Команда разработки Паспорта
PASSPORT_TEAM_DEV = [
    'kmerenkov',
    'eugene311',
    'andrey1931',
    'sotskov',
    'kanavis',
    'ov-al',
]

# Админы Паспорта
PASSPORT_TEAM_ADMIN = [
    'avmm',
    'abbat',
    'defg',
]

NAMESPACES_FOR_ADMINS = [
    'blackbox',
    'blackbox_by_client',
]

# Команда социального брокера
SOCIAL_API_TEAM = [
    'kmerenkov',
    'eugene311',
    'andrey1931',
    'sotskov',
    'kanavis',
    'ov-al',
]

# Команда Я.СМС
YASMS_TEAM = [
    'cerevra',
    'karganov',
    'ramilmsh',
]

NS_CACHE_DNS_IP = '2a02:6b8::1:1'

NAMESPACES_BY_CLIENT = [
    'blackbox_by_client',
    'passport',
    'historydb',
    'meltingpot',
    'oauth',
    'social api',
    'social broker',
    'social proxy',
    'takeout',
    'yasms',
]

NAMESPACES_WITH_REQUIRED_CLIENT = [
    'blackbox_by_client',
]

SSL_CA_CERT = '/etc/ssl/certs/ca-certificates.crt'

HIDDEN_NAMESPACES = []

ANOREXIA_THRESHOLD = 0.3

if ENV_TYPE in {'development', 'testing'}:
    ZOOKEEPER_HOSTS = [
        'zk-test.passport.yandex.net',
    ]
else:
    ZOOKEEPER_HOSTS = [
        'zk-m1.passport.yandex.net',
        'zk-s1.passport.yandex.net',
        'zk-v1.passport.yandex.net',
    ]

PUNCHER_OAUTH_TOKEN = secrets.PUNCHER_OAUTH_TOKEN
STAFF_OAUTH_TOKEN = secrets.STAFF_OAUTH_TOKEN

STAFF_API_URL = 'https://staff-api.yandex-team.ru'
STAFF_API_TIMEOUT = 2
STAFF_API_RETRIES = 2

OAUTH_CONSUMER = 'grantushka'
