# -*- coding: utf-8 -*-
import sys

from .default import *
from .default import _current_user

DEBUG = True
TEMPLATE_DEBUG = True

# В dev-окружении пишем логи в текущую папку
if _current_user not in ('root', 'www-data'):
    DATABASES['default']['NAME'] += '_' + _current_user

INSTALLED_APPS += ('django_nose',)


CONDUCTOR_API_NO_CACHE = {
    'address': 'https://c.test.yandex-team.ru/api/',
    'timeout': 60,
    'retry': 2,
}

CONDUCTOR_API = {
    'address': 'https://c.test.yandex-team.ru/api-cached/',
    'timeout': 60,
    'retry': 2,
}

SITE_ID = 2

if _current_user not in ('root', 'www-data'):
    EMAIL_GRANT_ADMINS = ['%s@yandex-team.ru' % _current_user]
    EMAIL_NOTIFICATION_TO = ['%s@yandex-team.ru' % _current_user]
else:
    EMAIL_GRANT_ADMINS = ['eugene311@yandex-team.ru']
    EMAIL_NOTIFICATION_TO = ['eugene311@yandex-team.ru']

EXPORT_GRANTS_URL = 'https://%s.grantushka-dev.yandex-team.ru/grants/operations/' % _current_user

SOUTH_TESTS_MIGRATE = False

EMAIL_BACKEND = 'django.core.mail.backends.console.EmailBackend'

if 'test' in sys.argv:
    DATABASES['default'] = {'ENGINE': 'django.db.backends.sqlite3'}
    DATABASE_ROUTERS = []
    MIDDLEWARE_CLASSES.remove('django_replicated.middleware.ReplicationMiddleware')

    # При прогоне тестов не надо ходить в репо
    ENABLE_CVS_CHECKOUT = False

TEST_RUNNER = 'django_nose.NoseTestSuiteRunner'
NOSE_ARGS = [
    '--cover-package=passport_grants_configurator.apps.core',
    '--processes=8',
    '--process-timeout=300',
]
