# -*- coding: utf-8 -*
import sys
import yenv
from blackbox import (
    FIELD_LOGIN,
    XmlBlackbox,
)

from .default import *

from .secrets import (
    DB_USER,
    DB_PASSWORD,
    DB_SLAVE_USER,
    DB_SLAVE_PASSWORD,
    BITBUCKET_API_TOKEN,
)

MIDDLEWARE_CLASSES = [
    'passport_grants_configurator.apps.core.middlewares.PingMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django_replicated.middleware.ReplicationMiddleware',
    'django.middleware.locale.LocaleMiddleware',
    'django_yauth.middleware.YandexAuthMiddleware',
    'django.middleware.doc.XViewMiddleware',
]

TEMPLATE_LOADERS = [
    'django.template.loaders.filesystem.Loader',
    'django.template.loaders.app_directories.Loader',
]

TEMPLATE_DIRS = [
    os.path.join(PROJECT_DIR, 'templates'),
]

TEMPLATE_CONTEXT_PROCESSORS = (
    'django.contrib.auth.context_processors.auth',
    'django.contrib.messages.context_processors.messages',
    'django.core.context_processors.request',
    'django.core.context_processors.csrf',
    'django.core.context_processors.media',
    'django.core.context_processors.static',
    'django_yauth.context.yauth',
)

# YAUTH
YAUTH_BLACKBOX_INSTANCE = XmlBlackbox(XmlBlackbox.URLS['intranet']['production'], dbfields=[FIELD_LOGIN])
YAUTH_USE_NATIVE_USER = True
YAUTH_USE_SITES = False
YAUTH_TYPE = 'intranet'


INSTALLED_APPS = [
    'django_yauth',
    'django_template_common',
    'django_replicated',

    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.messages',
    'django.contrib.sessions',
    'django.contrib.staticfiles',
    'django.contrib.contenttypes',
    'django_idm_api',

    'passport_grants_configurator.apps.passport_admin_roles_adapter',
]

ROOT_URLCONF = 'passport_grants_configurator.passport_admin_roles_urls'

_current_user = os.environ.get('USER', os.environ.get('LOGNAME', 'root'))
if _current_user not in ('root', 'www-data'):
    for handler, config in LOGGING['handlers'].iteritems():
        if 'filename' in config:
            config['filename'] = os.path.basename(config['filename'])

PASSPORT_ADMIN_ROLES_GIT_API = {
    'api_timeout': 1,
    'api_token': BITBUCKET_API_TOKEN,
    'commits': 'https://bb.yandex-team.ru/rest/api/1.0/projects/tvm/repos/passport-admin-roles/commits',
    'committer': {
        'DEBFULLNAME': 'Passport Grants Robot',
        'DEBEMAIL': 'passport-admin@yandex-team.ru'
    },
    'project': 'passport_admin_roles',
    'repo': 'ssh://git@bb.yandex-team.ru/tvm/passport-admin-roles.git',
    'working_dir': '/var/lib/yandex/passport-grants-configurator/exports/passport_admin_roles/',
}

# Production пишет и читает __только__ из локальной БД
DB_NAME = 'passport_admin_roles'
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',
        'HOST': 'localhost',
        'NAME': DB_NAME,
        'USER': DB_USER,
        'PASSWORD': DB_PASSWORD,
    },
    'slave': {
        'ENGINE': 'django.db.backends.mysql',
        'HOST': 'localhost',
        'NAME': DB_NAME,
        'USER': DB_SLAVE_USER,
        'PASSWORD': DB_SLAVE_PASSWORD,
    },
}

DATABASE_SLAVES = ['slave']

# Храним права для Паспортной админки в модельке Permission,
# поэтому даём создавать права с именами больше стандартного
# ограничения в django.contrib.auth.models.Permission
PERMISSION_SIZE_NAME = 255

if yenv.type in ['production']:
    # Чтобы исключения возникающие в сопроцессах ZooKeeper, не проливались мимо,
    # перенаправим stderr в export_log.
    with open(LOG_PATH + 'export.log', 'a') as export_log:
        os.dup2(export_log.fileno(), sys.stderr.fileno())
        sys.stderr = os.fdopen(sys.stderr.fileno(), 'a')
