# -*- coding: utf-8 -*
from .default import *

from .secrets import (
    DB_USER,
    DB_PASSWORD,
    DB_SLAVE_USER,
    DB_SLAVE_PASSWORD,
)


# Production пишет и читает __только__ из локальной БД
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',
        'HOST': 'localhost',
        'NAME': DB_NAME,
        'USER': DB_USER,
        'PASSWORD': DB_PASSWORD,
    },
    'slave': {
        'ENGINE': 'django.db.backends.mysql',
        'HOST': 'localhost',
        'NAME': DB_NAME,
        'USER': DB_SLAVE_USER,
        'PASSWORD': DB_SLAVE_PASSWORD,
    },
}

DATABASE_SLAVES = ['slave']

SITE_ID = 3

EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'
EMAIL_GRANT_ADMINS = ['grantushka-admin@yandex-team.ru']

EXPORT_GRANTS_URL = 'https://grantushka.yandex-team.ru/grants/operations/'

SIMULATE_EXPORT_GRANTS = False
