# -*- coding: utf-8 -*-
# isort:skip_file
import os
from imp import load_source


for config_file in (
    '/usr/lib/yandex/passport-grants-configurator-secrets/local_settings.py',
    os.path.join(os.path.dirname(__file__), 'default.py'),
):
    try:
        load_source('secret_settings', config_file)
        break
    except IOError:
        pass


from secret_settings import (
    DB_USER,
    DB_PASSWORD,
    DB_SLAVE_USER,
    DB_SLAVE_PASSWORD,
    SECRET_KEY,
    GIT_API_TOKEN,
    BITBUCKET_API_TOKEN,
    REDIS_PASSWORD,
    STAFF_OAUTH_TOKEN,
    PUNCHER_OAUTH_TOKEN,
)
