from django.conf import settings
from django.conf.urls import *
from django.views.generic.base import RedirectView

from django.contrib import admin

admin.autodiscover()

urlpatterns = patterns(
    '',
    url(r'^grants/', include('passport_grants_configurator.apps.core.urls')),
    url(r'^$', RedirectView.as_view(url='grants/')),
    url(r'^admin/', include(admin.site.urls)),
)


if settings.ENV_TYPE == 'development':
    from django.conf.urls.static import static

    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
