import os

from setuptools import setup, find_packages


def find_data(package, start_from, exclude_exts=[], exclude_dirs=[]):
    def inner():
        for root, dirs, files in os.walk(os.path.join(package, start_from)):
            dirs[:] = [d for d in dirs if d not in exclude_dirs]

            extensions = map(os.path.splitext, files)
            extensions = set(ext[1] for ext in extensions if ext[1][1:] not in exclude_exts)

            for ext in filter(None, extensions):
                filename = os.path.relpath(os.path.join(root, '*' + ext), package)
                yield filename
    return {package: list(inner())}

setup(
    name='yandex-passport-grants-configurator',
    description='Yandex grant service',
    author='Yandex passport team',
    author_email='passport-dev@yandex-team.ru',
)
