from passport.backend.library.commander.commander import ArgumentGroup
import yenv


def create_env_argument(available_environments=None):
    if available_environments is None:
        available_environments = ['development', 'rc', 'production']

    def get_environmets(string):
        if string == 'all':
            return available_environments
        else:
            return [string]

    return ArgumentGroup(
        '--env',
        dest='environments',
        type=get_environmets,
        default=yenv.type,
        help='environment name or `all` for all environments',
    )


env_argument = create_env_argument()
