from threading import Lock


class ExponentialBackoff:
    def __init__(self, start_value, multiplier, max_value, threaded=False):
        self._start_value = start_value
        self._multiplier = multiplier
        self._max_value = max_value
        self._next_backoffs = {}
        self._lock = Lock()
        self._threaded = threaded

    def __call__(self, host):
        if self._threaded:
            self._lock.acquire()
        next_backoff = self._next_backoffs.get(host, self._start_value)
        self._next_backoffs[host] = min(self._max_value, next_backoff * self._multiplier)
        if self._threaded:
            self._lock.release()
        return next_backoff

    def reset(self, host):
        if self._threaded:
            self._lock.acquire()
        self._next_backoffs[host] = self._start_value
        if self._threaded:
            self._lock.release()
