class AggregatorsHolder(object):
    def __init__(self, aggregators):
        self.by_event = {}
        self.by_name = {}
        if aggregators is not None:
            for agg_name, agg_obj in aggregators.items():
                self.by_name[agg_name] = agg_obj
                self.by_event.setdefault(agg_obj.event, []).append(agg_obj)

    def __getitem__(self, index):
        return self.by_name[index].get_value()

    def proceed_by_event(self, event, **fields):
        if event in self.by_event:
            for agg in self.by_event[event]:
                agg.proceed(**fields)
