class EventMachine(object):
    '''EventMachine is a manager for EventStream.
    It runs operations for the collection of EventStreams'''
    def __init__(self, **event_streams):
        self.event_streams = event_streams

    def add(self, event, timestamp, **fields):
        for event_stream in self.event_streams.values():
            event_stream.add(event, timestamp, **fields)

    def process(self, events):
        for event in events:
            self.add(event[0], event[1], **event[2])

    def __getitem__(self, index):
        return self.event_streams[index]
