# -*- coding: utf-8 -*-
import logging

from passport.backend.library.historydbloader.historydb.utils import (
    entry_to_userip,
    pack_unsigned_int_be,
    pack_unsigned_long_be,
)


log = logging.getLogger('workers.historydb.hbase_converter')


SECONDS_IN_HOUR = 60 * 60
MAX_UINT = 2 ** 32 - 1


class AggregateAuthHelper(object):
    def __init__(self, entry):
        self.entry = entry

    def build_row(self, tail):
        timestamp = self.entry['timestamp']
        hours = int(timestamp) / SECONDS_IN_HOUR
        return (
            self.build_success_auths_aggregated_row_uid_prefix(self.entry['uid']) +
            pack_unsigned_int_be(MAX_UINT - hours) + tail)

    @staticmethod
    def build_success_auths_aggregated_row_uid_prefix(uid):
        return '%03d%s' % (
            int(str(uid)[-3:]),
            pack_unsigned_long_be(uid),
        )

    def fill_ip_info(self, auth_info):
        ip_info = auth_info.ip_info
        ip_info.ip = self.entry.get('ip.packed')
        # FIXME: entry: dict -> some cls
        geoid = self.entry.get('ip.geoid')
        if geoid:
            ip_info.geoId = geoid
        AS_list = self.entry.get('ip.as_list')
        if AS_list:
            AS = AS_list[0]
            ip_info.AS = int(AS[2:])

    def is_entry_writeable(self):
        user_ip = entry_to_userip(self.entry)
        if not user_ip:
            log.warning('UserIP not found: %s', self.entry)
            return False

        if self.entry.get('ip.is_yandex'):
            return False

        if not self.entry.get('ip.is_real'):
            return False

        binary_ip = self.entry.get('ip.packed')
        if not binary_ip:
            log.warning('UserIP.packed not found: %s', self.entry)
            return False

        return True
