import re


def _atoi(text):
    return int(text) if text.isdigit() else text


def _natural_keys(text):
    return [_atoi(c) for c in re.split(r'(\d+)', text)]


def nsorted(to_sort, key=None):
    """Returns a naturally sorted list"""
    if key is None:
        key_callback = _natural_keys
    else:
        def key_callback(item):
            return _natural_keys(key(item))

    return sorted(to_sort, key=key_callback)
