# -*- coding: utf-8 -*-

import logging
import time

from flask import request


class RequestEnricher(logging.Filter):
    def filter(self, record):
        record.request = bool(request)
        record.unixtime = time.time()
        record.formatted_unixtime = '{:.3f}'.format(round(record.unixtime, 3))
        if request:
            record.request_id = request.request_id
            record.user_agent = request.real_user_agent
            record.user_ip = request.user_ip
            record.path = request.full_path
            record.method = request.method
            if hasattr(request, 'remote_ip'):
                record.remote_ip = request.remote_ip
        return True
