# -*- coding: utf-8 -*-

import os

from passport.backend.utils.file import (
    chown,
    parse_owner,
)
import ylog.handlers


class OSFileHandler(ylog.handlers.OSFileHandler):
    def __init__(self, filename, encoding='utf-8', mode=0o644, owner=None, *args, **kwargs):
        super(OSFileHandler, self).__init__(
            filename,
            encoding=encoding,
            mode=mode,
            *args,
            **kwargs
        )
        filename = os.path.expanduser(filename)
        if owner:
            user, group = parse_owner(owner)
            chown(filename, user, group)
