# -*- coding: utf-8 -*-
import re
import subprocess

from setuptools import (
    find_packages,
    setup,
)
from setuptools.command.install_lib import install_lib as InstallLibOrig


PREFIX = 'passport_backend_library_nginx_config_generator'


# FIXME: оторвать костыли по патчингу импортов (тут и в debian/postinst) после перехода на py3 или
#  иного решения проблемы в https://st.yandex-team.ru/PYTHONCOM-255
class InstallLib(InstallLibOrig):
    def build(self):
        p = subprocess.Popen(['deb/patch_imports.sh', '.'], cwd='.', shell=False, stdout=subprocess.PIPE)
        for line in iter(p.stdout.readline, b''):
            print line.rstrip()
        InstallLibOrig.build(self)


def _get_version():
    changelog = subprocess.check_output(['dpkg-parsechangelog'], cwd='deb/', shell=False)
    changelog = changelog.decode('utf-8')
    match = re.search(r'^Version: (.+)$', changelog, re.MULTILINE)
    return match.group(1)


setup(
    name='yandex-passport-nginx-config-generator',
    version=_get_version(),
    description='Building nginx configs from templates',
    url='https://a.yandex-team.ru/arc/trunk/arcadia/passport/backend/library/nginx_config_generator',
    author='Passport team',
    author_email='passport-dev@yandex-team.ru',
    package_dir={PREFIX: '.'},
    packages=[
        PREFIX,
        '%s.test' % PREFIX,
    ],
    package_data={
        '': [
            'base_macros.j2',
            'deb/debian/changelog',
            'deb/patch_imports.sh',
        ],
    },
    install_requires=[
        'Jinja2==2.7.3',
        'yenv',
    ],
    cmdclass={
        'install_lib': InstallLib,
    },
)
