# -*- coding: utf-8 -*-
import re
import socket


def camel_case_to_snake_case(name):
    s1 = re.sub('(.)([A-Z][a-z]+)', r'\1_\2', name)
    return re.sub('([a-z0-9])([A-Z])', r'\1_\2', s1).lower()


def get_fqdn():
    return socket.getfqdn()


def get_ip(fqdn, ip_family):
    return socket.getaddrinfo(fqdn, 0, ip_family)[0][4][0]
