package passportapi

import (
	"net/http"
	"time"

	"a.yandex-team.ru/library/go/yandex/tvm"
)

type client struct {
	Client      *http.Client
	Consumer    string
	Environment Environment
	TvmClient   tvm.Client
}

var _ APIClient = (*client)(nil)

type Environment struct {
	BaseURL string
	TVMID   tvm.ClientID
}

var (
	EnvTesting = Environment{
		"https://passport-test-internal.yandex.ru",
		2000079,
	}
	EnvProduction = Environment{
		"https://passport-internal.yandex.ru",
		2000078,
	}
)

type Headers struct {
	YaClientHost       string
	YaClientUserAgent  string
	YaClientIP         string
	YaClientCookie     string
	YaClientXRequestID string
}

func DefaultHTTPClient(timeout time.Duration) *http.Client {
	var httpClient = &http.Client{
		Timeout: timeout,
		// отключает следование по редиректам
		CheckRedirect: func(req *http.Request, via []*http.Request) error {
			return http.ErrUseLastResponse
		},
	}
	return httpClient
}

func NewPassportAPIClient(consumer string, tvmClient tvm.Client, env Environment, timeout time.Duration) (*client, error) {
	return &client{
		Client:      DefaultHTTPClient(timeout),
		Consumer:    consumer,
		Environment: env,
		TvmClient:   tvmClient,
	}, nil
}
