package passportapi

import (
	"context"
	"encoding/json"
	"fmt"
)

func (c *client) DeleteAccount(ctx context.Context, headers Headers, uid uint64) (BaseResponse, error) {
	var parsedResponse BaseResponse

	path := fmt.Sprintf("/1/bundle/account/%d/", uid)
	_, body, err := c.request(ctx, "DELETE", path, headers, nil)
	if err != nil {
		return parsedResponse, err
	}

	if err := json.Unmarshal(body, &parsedResponse); err != nil {
		return parsedResponse, err
	}
	return parsedResponse, nil
}
