package passportapi

import (
	"context"
	"encoding/json"
	"net/url"
	"strconv"
)

type EditFederalRequest struct {
	UID         uint64
	FirstName   string
	LastName    string
	EMails      []string
	Active      bool
	DisplayName string
	Headers     Headers
}

func (c *client) EditFederal(ctx context.Context, headers Headers, req EditFederalRequest) (BaseResponse, error) {
	var (
		parsedResponse BaseResponse
		active         string
	)

	if req.Active {
		active = "1"
	} else {
		active = "0"
	}

	values := map[string]string{
		"firstname":    req.FirstName,
		"lastname":     req.LastName,
		"active":       active,
		"display_name": req.DisplayName,
		"uid":          strconv.FormatUint(req.UID, 10),
	}

	formData := url.Values{}
	for key, value := range values {
		if len(value) > 0 {
			formData.Add(key, value)
		}
	}
	for _, value := range req.EMails {
		formData.Add("emails", value)
	}

	_, body, err := c.request(
		ctx,
		"POST",
		"/1/bundle/account/federal/change/",
		headers,
		formData,
	)
	if err != nil {
		return parsedResponse, err
	}

	if err := json.Unmarshal(body, &parsedResponse); err != nil {
		return parsedResponse, err
	}
	return parsedResponse, nil
}
