package passportapi

import (
	"context"
	"encoding/json"
	"fmt"
	"net/url"
	"strconv"
)

type RegisterFederalRequest struct {
	FirstName   string
	LastName    string
	EMail       string
	Active      bool
	NameID      string
	DomainID    uint64
	DisplayName string
	Headers     Headers
}

type rawRegisterFederalResponse struct {
	BaseResponse
	UID uint64 `json:"uid"`
}

type RegisterFederalResponse struct {
	BaseResponse
	UID uint64
}

func (c *client) RegisterFederal(ctx context.Context, headers Headers, req RegisterFederalRequest) (RegisterFederalResponse, error) {
	var (
		parsedResponse RegisterFederalResponse
		active         string
		domainID       string
	)

	if req.Active {
		active = "1"
	} else {
		active = "0"
	}
	domainID = strconv.FormatUint(req.DomainID, 10)

	values := map[string]string{
		"firstname":    req.FirstName,
		"lastname":     req.LastName,
		"email":        req.EMail,
		"active":       active,
		"name_id":      req.NameID,
		"domain_id":    domainID,
		"display_name": req.DisplayName,
	}
	formData := url.Values{}
	for key, value := range values {
		if len(value) > 0 {
			formData.Add(key, value)
		}
	}

	_, body, err := c.request(ctx, "POST", "/1/bundle/account/register/federal/", headers, formData)
	if err != nil {
		return parsedResponse, err
	}

	if err := json.Unmarshal(body, &parsedResponse); err != nil {
		return parsedResponse, err
	}
	if parsedResponse.Status == "ok" && parsedResponse.UID == 0 {
		return parsedResponse, fmt.Errorf("missing uid in response from passport")
	}

	return parsedResponse, nil
}
