import os

from passport.backend.library.repo.arc import ArcManager
from passport.backend.library.repo.hg import HgManager
from passport.backend.library.repo.svn import SvnManager
from passport.backend.utils.file import parent_chain


def _is_repository(path):
    if os.path.exists(os.path.join(path, '.arc')):
        return 'arc'
    elif os.path.exists(os.path.join(path, '.hg')):
        return 'hg'
    elif os.path.exists(os.path.join(path, '.svn')):
        return 'svn'


def get_repository_info(basedir='.'):
    for f in parent_chain(basedir):
        is_repository = _is_repository(f)
        if is_repository:
            return {
                'type': is_repository,
                'path': f,
            }


def get_repository_manager(basedir='.'):
    repository_info = get_repository_info(basedir=basedir)
    repositories = {
        'arc': ArcManager(),
        'hg': HgManager(),
        'svn': SvnManager(),
    }
    repository = repositories.get(repository_info.get('type'))
    if not repository:
        raise RuntimeError('Unknown repository type')
    return repository


def get_relative_path(filepath):
    filepath = os.path.abspath(filepath)
    repository_info = get_repository_info(basedir=filepath)
    return os.path.relpath(filepath, repository_info['path'])


__all__ = [
    'ArcManager', 'HgManager', 'SvnManager', 'get_repository_manager', 'get_relative_path', 'get_repository_info'
]
