from collections import namedtuple


Commit = namedtuple('Commit', ['author', 'message', 'unixtime', 'hash'])


class CommitSearchResult(object):
    def __init__(self, commits_since, found_commit):
        self.found_commit = found_commit
        self.commits_since = list(sorted(commits_since, key=lambda x: x.unixtime))

    def extend(self, other):
        c1 = self.commits_since
        c2 = other.commits_since
        visited = set()
        uniqued_commit_list = []
        for el in c1 + c2:
            if el.hash not in visited:
                visited.add(el.hash)
                uniqued_commit_list.append(el)

        return CommitSearchResult(
            commits_since=uniqued_commit_list,
            found_commit=self.found_commit,
        )


class BaseManager(object):
    def pull_request(self, files, message, branch_name):
        raise NotImplementedError()

    def get_commits_since(self, directory='.', commit_hash=None, message=None, target_date=None):
        raise NotImplementedError()

    def revert(self, file):
        raise NotImplementedError()

    def is_touched(self, file):
        raise NotImplementedError()
