from bisect import bisect
from functools import partial
import textwrap


def split(field_name, pivot_points):
    argnames = ','.join(['arg%d' % i for i in range(len(pivot_points))])
    ldict = locals()
    code = '''
    def _outer(field_name, pivot_points, records, {argnames}):
        def _mapper(field_name, pivot_points, records, *destinations):
            for record in records:
                destination_index = bisect(pivot_points, record[field_name])
                if destination_index:
                    destinations[destination_index - 1](record)
        _mapper(field_name, pivot_points, records, {argnames})
    '''.format(argnames=argnames)
    code = textwrap.dedent(code)
    exec(code, globals(), ldict)
    return partial(ldict['_outer'], field_name, list(pivot_points))


def drop_fields(*names):
    def dropper(records):
        for record in records:
            for name in names:
                if hasattr(record, name):
                    delattr(record, name)
            yield record
    return dropper
