#pragma once
#include <algorithm>
#include <string>
#include <vector>
#include <unordered_map>

using std::vector;
using std::unordered_map;
using std::lower_bound;
using std::upper_bound;
using std::string;
using std::pair;

template <class key_type, class val_type>
class IntervalCounters {
private:
    unordered_map<key_type, vector<val_type> > counters = unordered_map<key_type, vector<val_type> >();
public:
    void add(const key_type& key, const val_type& val);
    uint32_t count(const key_type& key, const val_type& begin, const val_type& end);
    uint32_t count_before(const key_type& key, const val_type& end);
    uint32_t count_after(const key_type& key, const val_type& begin);
    bool has(const key_type& key);
};

template <class key_type, class val_type>
class PartialIntervalCounters {
public:
    typedef pair<val_type, uint32_t> val_pair_type;
    struct PartialLesserComparator_{
        bool operator()(const val_pair_type& a, const val_type& b) {
            return a.first < b;
        }
        bool operator()(const val_type& a, const val_pair_type& b) {
            return a < b.first;
        }
    };
    struct PartialGreaterComparator_{
        bool operator()(const val_pair_type& a, const val_type& b) {
            return a.first > b;
        }
        bool operator()(const val_type& a, const val_pair_type& b) {
            return a > b.first;
        }
    };
    static constexpr PartialLesserComparator_ LesserComparator = PartialLesserComparator_();
    static constexpr PartialGreaterComparator_ GreaterComparator = PartialGreaterComparator_();
    void add(const key_type& key, const val_type& val, uint32_t counter);
    uint32_t count(const key_type& key, const val_type& begin, const val_type& end);
    uint32_t count_before(const key_type& key, const val_type& end);
    uint32_t count_after(const key_type& key, const val_type& begin);
    bool has(const key_type& key);
private:
    unordered_map<key_type, vector<val_pair_type> > counters = unordered_map<key_type, vector<val_pair_type> >();
};
