#pragma once
#include <cmath>
#include <limits>
#include <vector>
#include <algorithm>

class RunningStats
{
public:
    RunningStats();
    void clear();
    void push(const double&);
    void append(const std::vector<double>&);
    uint32_t size() const;
    double mean() const;
    double sum() const;
    double max() const;
    double min() const;
    double var() const;
    double std() const;
    double skewness() const;
    double kurtosis() const;

    friend RunningStats operator+(const RunningStats&, const RunningStats&);
    RunningStats& operator+=(const RunningStats&);

private:
    uint32_t n;
    double M1, M2, M3, M4, min_val, max_val, sum_val, nan_val;
};
