#include "series.h"

template<class val_type>
void Series<val_type>::add(const val_type& val) {
    this->sum += val;
    this->sq_sum += (val*val);
    this->values.push_back(val);
}

template<class val_type>
unique_ptr<Series<val_type> > Series<val_type>::diff() {
    auto size = this->values.size();
    std::unique_ptr<Series> result(new Series(size - 1));
    #pragma omp parallel for if(parallelism_enabled)
    for (size_t i = 1; i < size; ++i)
        result->values[i] = this->values[i] - this->values[i - 1];
    return result;
}

template<class val_type>
Series<val_type>::Series(typename std::vector<val_type>::size_type n) {
    this->values = vector<val_type>(n);
}

template class Series<int32_t>;
template class Series<int64_t>;
template class Series<float>;
