#pragma once
#include <algorithm>
#include <string>
#include <vector>
#include <unordered_map>

using std::vector;
using std::unordered_map;
using std::lower_bound;
using std::upper_bound;
using std::string;
using std::pair;
using std::unique_ptr;

extern int parallelism_enabled;

template <class val_type>
class Series {
private:
    vector<val_type> values;
    val_type sum;
    val_type sq_sum;
public:
    Series(typename std::vector<val_type>::size_type n = 0);
    void add(const val_type& val);
    unique_ptr<Series> diff();
};

typedef Series<int32_t> Int32Series;
typedef Series<int64_t> Int64Series;
typedef Series<float> FloatSeries;
