#include <sys/stat.h>
#include <cerrno>
#include <cstring>
#include <stdexcept>

#include "stl_set.h"

off_t GetFileLength(std::string const& filename)
{
    struct stat st;
    if (stat(filename.c_str(), &st) == -1)
        throw std::runtime_error(std::strerror(errno));
    return st.st_size;
}


template<class val_type>
void StlSet<val_type>::add(const val_type& val) {
    this->values.insert(val);
}

template<class val_type>
bool StlSet<val_type>::has(const val_type& val) const {
    return this->values.count(val) == 1;
}

template<class val_type>
uint32_t StlSet<val_type>::size() const {
    return this->values.size();
}

template<class val_type>
StlSet<val_type>::StlSet() {}

template<class val_type>
StlSet<val_type>::StlSet(const std::string& fname) {
    struct stat st;
    if (stat(fname.c_str(), &st) == -1)
        throw std::runtime_error(std::strerror(errno));
    ifstream fin(fname, std::ios::in | std::ios::binary);
    val_type num;
    this->values.reserve(st.st_size / sizeof(num));
    while (fin.read((char*)&num, sizeof(num)))
        this->values.insert(num);
    fin.close();
}

template class StlSet<int32_t>;
template class StlSet<uint32_t>;
template class StlSet<int64_t>;
template class StlSet<uint64_t>;
