#pragma once

#include <string>
#include <unordered_set>
#include <fstream>
#include <iostream>

using std::unordered_set;
using std::string;
using std::ifstream;
using std::cout;

template <class val_type>
class StlSet {
private:
    unordered_set<val_type> values;
public:
    StlSet();
    StlSet(const std::string& fname);
    void add(const val_type& val);
    bool has(const val_type& val) const;
    uint32_t size() const;
};


typedef StlSet<int32_t> Int32StlSet;
typedef StlSet<uint32_t> UInt32StlSet;
typedef StlSet<int64_t> Int64StlSet;
typedef StlSet<uint64_t> UInt64StlSet;
