# coding: utf-8
from libc.stdint cimport uint32_t, uint64_t
from libcpp cimport bool as bool_t
from libcpp.string cimport string


cdef extern from "interval_counters.h" nogil:
    cdef cppclass IntervalCounters[K, V]:
        void add(const K& key, const V& val)
        uint32_t count(const K& key, const V& begin, const V& end)
        uint32_t count_before(const K& key, const V& end)
        uint32_t count_after(const K& key, const V& begin)
        bool_t has(const K& key)

    cdef cppclass PartialIntervalCounters[K, V]:
        void add(const K& key, const V& val, uint32_t counter)
        uint32_t count(const K& key, const V& begin, const V& end)
        uint32_t count_before(const K& key, const V& end)
        uint32_t count_after(const K& key, const V& begin)
        bool_t has(const K& key)


cdef class UInt64PartialIntervalCounters:
    cdef PartialIntervalCounters[uint64_t, uint32_t]* _counters

    def __init__(self):
        self._counters = new PartialIntervalCounters[uint64_t, uint32_t]()

    def __deleter__(self):
        del self._counters
        self._counters = NULL

    def __dealloc__(self):
        self.__deleter__()

    def add(self, key, value, counter):
        return self._counters.add(key, value, counter)

    def count(self, key, begin, end):
        return self._counters.count(key, begin, end)

    def count_before(self, key, end):
        return self._counters.count_before(key, end)

    def count_after(self, key, begin):
        return self._counters.count_after(key, begin)

    def has(self, key):
        return self._counters.has(key)


cdef class UInt64IntervalCounters:
    cdef IntervalCounters[uint64_t, uint32_t]* _counters

    def __init__(self):
        self._counters = new IntervalCounters[uint64_t, uint32_t]()

    def __deleter__(self):
        del self._counters
        self._counters = NULL

    def __dealloc__(self):
        self.__deleter__()

    def add(self, key, value):
        return self._counters.add(key, value)

    def count(self, key, begin, end):
        return self._counters.count(key, begin, end)

    def count_before(self, key, end):
        return self._counters.count_before(key, end)

    def count_after(self, key, begin):
        return self._counters.count_after(key, begin)

    def has(self, key):
        return self._counters.has(key)

cdef class UInt32IntervalCounters:
    cdef IntervalCounters[uint32_t, uint32_t]* _counters

    def __init__(self):
        self._counters = new IntervalCounters[uint32_t, uint32_t]()

    def __deleter__(self):
        del self._counters
        self._counters = NULL

    def __dealloc__(self):
        self.__deleter__()

    def add(self, key, value):
        return self._counters.add(key, value)

    def count(self, key, begin, end):
        return self._counters.count(key, begin, end)

    def count_before(self, key, end):
        return self._counters.count_before(key, end)

    def count_after(self, key, begin):
        return self._counters.count_after(key, begin)

    def has(self, key):
        return self._counters.has(key)

cdef class StringIntervalCounters:
    cdef IntervalCounters[string, uint32_t]* _counters

    def __init__(self):
        self._counters = new IntervalCounters[string, uint32_t]()

    def __deleter__(self):
        del self._counters
        self._counters = NULL

    def __dealloc__(self):
        self.__deleter__()

    def add(self, key, value):
        return self._counters.add(key, value)

    def count(self, key, begin, end):
        return self._counters.count(key, begin, end)

    def count_before(self, key, end):
        return self._counters.count_before(key, end)

    def count_after(self, key, begin):
        return self._counters.count_after(key, begin)

    def has(self, key):
        return self._counters.has(key)
