# coding: utf-8
from libc.stdint cimport int32_t, uint32_t
from libcpp.vector cimport vector


cdef extern from "running_stats.h" nogil:
    cdef cppclass RunningStats:
        RunningStats()
        void clear()
        void append(const vector[double]&)
        void push(const double)
        uint32_t size() const
        double mean() const
        double sum() const
        double max() const
        double min() const
        double var() const
        double std() const
        double skewness() const
        double kurtosis() const

        RunningStats operator+(const RunningStats&, const RunningStats&)


cdef class RunningStatistics:
    cdef RunningStats* _running_stats

    def __init__(self):
        self._running_stats = new RunningStats()

    def __deleter__(self):
        del self._running_stats
        self._running_stats = NULL

    def __dealloc__(self):
        self.__deleter__()

    def clear(self):
        return self._running_stats.clear()

    def push(self, x):
        return self._running_stats.push(x)

    def append(self, arr):
        return self._running_stats.append(arr)

    def size(self):
        return self._running_stats.size()

    def mean(self):
        return self._running_stats.mean()

    def size(self):
        return self._running_stats.size()

    def sum(self):
        return self._running_stats.sum()

    def max(self):
        return self._running_stats.max()

    def min(self):
        return self._running_stats.min()

    def var(self):
        return self._running_stats.var()

    def std(self):
        return self._running_stats.std()

    def skewness(self):
        return self._running_stats.skewness()

    def kurtosis(self):
        return self._running_stats.kurtosis()
