# coding: utf-8
from libc.stdint cimport int32_t, int64_t
from libcpp.vector cimport vector


cdef extern from "series.h" nogil:
    cdef cppclass Series[V]:
        Series(vector[V].size_type n)
        void add(const V& val)


cdef class Int32Series:
    cdef Series[int32_t]* _series

    def __cinit__(self, const int32_t n=0):
        self._series = new Series[int32_t](n)

    def __deleter__(self):
        del self._series
        self._series = NULL

    def __dealloc__(self):
        self.__deleter__()

    def add(self, val):
        return self._series.add(val)


cdef class Int64Series:
    cdef Series[int64_t]* _series

    def __cinit__(self, const int32_t n=0):
        self._series = new Series[int64_t](n)

    def __deleter__(self):
        del self._series
        self._series = NULL

    def __dealloc__(self):
        self.__deleter__()

    def add(self, val):
        return self._series.add(val)


cdef class FloatSeries:
    cdef Series[float]* _series

    def __cinit__(self, const int32_t n=0):
        self._series = new Series[float](n)

    def __deleter__(self):
        del self._series
        self._series = NULL

    def __dealloc__(self):
        self.__deleter__()

    def add(self, val):
        return self._series.add(val)
