# coding: utf-8
from libc.stdint cimport int32_t, uint32_t, int64_t, uint64_t
from libcpp.string cimport string
from libcpp cimport bool as bool_t


cdef extern from "stl_set.h" nogil:
    cdef cppclass StlSet[V]:
        StlSet()
        StlSet(const string& fname);
        void add(const V& val);
        bool_t has(const V& val) const;
        uint32_t size() const;


cdef class Int32StlSet:
    cdef StlSet[int32_t]* _set

    def __init__(self, fname=None):
        if fname is not None:
            self._set = new StlSet[int32_t](fname)
        else:
            self._set = new StlSet[int32_t]()

    def __deleter__(self):
        del self._set
        self._set = NULL

    def __dealloc__(self):
        self.__deleter__()

    def add(self, val):
        return self._set.add(val)

    def has(self, val):
        return self._set.has(val)

    def size(self):
        return self._set.size()


cdef class UInt32StlSet:
    cdef StlSet[uint32_t]* _set

    def __init__(self, fname=None):
        if fname is not None:
            self._set = new StlSet[uint32_t](fname)
        else:
            self._set = new StlSet[uint32_t]()

    def __deleter__(self):
        del self._set
        self._set = NULL

    def __dealloc__(self):
        self.__deleter__()

    def add(self, val):
        return self._set.add(val)

    def has(self, val):
        return self._set.has(val)

    def size(self):
        return self._set.size()


cdef class Int64StlSet:
    cdef StlSet[int64_t]* _set

    def __init__(self, fname=None):
        if fname is not None:
            self._set = new StlSet[int64_t](fname)
        else:
            self._set = new StlSet[int64_t]()

    def __deleter__(self):
        del self._set
        self._set = NULL

    def __dealloc__(self):
        self.__deleter__()

    def add(self, val):
        return self._set.add(val)

    def has(self, val):
        return self._set.has(val)

    def size(self):
        return self._set.size()


cdef class UInt64StlSet:
    cdef StlSet[uint64_t]* _set

    def __init__(self, fname=None):
        if fname is not None:
            self._set = new StlSet[uint64_t](fname)
        else:
            self._set = new StlSet[uint64_t]()

    def __deleter__(self):
        del self._set
        self._set = NULL

    def __dealloc__(self):
        self.__deleter__()

    def add(self, val):
        return self._set.add(val)

    def has(self, val):
        return self._set.has(val)

    def size(self):
        return self._set.size()

