# -*-  coding: utf-8 -*-
import argparse
import getpass
import json
import os
import sys

from passport.backend.libs_checker import conf
from passport.backend.libs_checker.checker import libs_checker
from passport.backend.utils.warnings import enable_strict_bytes_mode


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-v', '--verbose', action='store_true', default=False)
    args = parser.parse_args()
    return args


def disable_console_output():
    devnull = open(os.devnull, 'w')
    sys.stdout = sys.stderr = devnull


def get_target_libs(config):
    json_config_path = config.get('config_path')
    if json_config_path and os.path.exists(json_config_path):
        with open(json_config_path, 'r') as config_file:
            json_config = json.load(config_file)
        target_libs = json_config['target_libs']
        if not all(target_lib in config['supported_libs'] for target_lib in target_libs):
            raise ValueError('Unsupported library in config')
        return target_libs
    else:
        return list(config['supported_libs'].keys())


def run_app():
    enable_strict_bytes_mode()
    args = parse_args()

    conf.configure_settings()
    config = conf.get_config()

    if getpass.getuser() != config['expected_username']:
        print('This script should be executed by "{}" user'.format(config['expected_username']))
        sys.exit(1)

    if not args.verbose:
        disable_console_output()

    target_libs = get_target_libs(config)
    libs_checker(config, target_libs, args.verbose)
