# -*- coding: utf-8 -*-
from passport.backend.core.lazy_loader import LazyLoader
from passport.backend.library.configurator import Configurator


def _get_config_list():
    return [
        'logs.yaml',
        'settings-common.yaml',
    ]


LazyLoader.register(
    'config',
    Configurator,
    name='passport-libs-checker',
    configs=_get_config_list(),
)


def configure_settings():
    config = get_config()
    config.set_logging()


def get_config():
    return LazyLoader.get_instance('config')
