# -*- coding: utf-8 -*-
import shutil

from passport.backend.libs_checker.conf import get_config
from passport.backend.libs_checker.utils import (
    make_target_path,
    make_temp_target_path,
)


class StagingEnvironment(object):
    @classmethod
    def setup_original_environment(cls, target_libs):
        conf = get_config()
        env = {}
        for library_name in target_libs:
            env[library_name] = conf['supported_libs'][library_name]
        cls.env = env

    @classmethod
    def setup_target_environment(cls, target_libs, updated_libs):
        conf = get_config()
        env = {}
        for library_name in target_libs:
            env[library_name] = {}
            source_paths = conf['supported_libs'][library_name]
            for file_name, source_path in source_paths.items():
                env[library_name][file_name] = target_path = make_target_path(source_path)
                if library_name in updated_libs:
                    temp_path = make_temp_target_path(target_path)
                    shutil.copy2(source_path, temp_path)
                    env[library_name][file_name] = temp_path
        cls.updated_libs = updated_libs
        cls.env = env

    @classmethod
    def commit_changes(cls):
        conf = get_config()
        for library_name in cls.updated_libs:
            for source_path in conf['supported_libs'][library_name].values():
                target_path = make_target_path(source_path)
                temp_path = make_temp_target_path(target_path)
                shutil.move(temp_path, target_path)
