# -*- coding: utf-8 -*-


class BaseLibsCheckerError(Exception):
    """Базовый класс для обрабатываемых ошибок"""


class SourceNotFoundError(BaseLibsCheckerError):
    """Исходный файл не найден"""


class TargetNotAFileError(BaseLibsCheckerError):
    """Целевой путь указывает на директорию"""


class TestsFailedError(BaseLibsCheckerError):
    """Тесты не пройдены"""
