#!/bin/sh

PYTHON_BIN="${PYTHON_BIN:-python}"
BASEDIR=$(dirname "$0")

$PYTHON_BIN -c 'import cookiecutter' > /dev/null 2>&1

if [ "$?" != "0" ]; then
    echo "No cookiecutter. Run 'pip install cookiecutter' or select another python bin by setting "'$PYTHON_BIN'
    exit
fi

_post_render_message=""
if [ "$1" = "lbc_http" ]; then
    _template="lbc_http"
elif [ "$1" = "lbc_proto_py3" ]; then
    _template="lbc_proto_py3"
    _post_render_message="Please set message class (marked with !!) in settings/<all_environments>.yaml, tests/test_handler.py"
else
    echo "Select template name: one of lbc_http, lbc_proto_py3"
    exit
fi

_outdir=`realpath "$BASEDIR/.."`
while [ : ]; do
    echo -n "Will render $_template template to $_outdir/{{project_slug_snake from following input}} [y/N] "
    read response
    case "$response" in
        [yY]) break; break;;
        [nN]|"") exit 0;;
    esac
done

$PYTHON_BIN -m cookiecutter "$BASEDIR/$_template" -o "$_outdir" && {
    echo "Render complete"
    if [ "$_post_render_message" ]; then
        echo "$_post_render_message"
    fi
}
