# -*- coding: utf-8 -*-


class ServiceFilter(object):
    def __init__(self, events_classes, sid):
        self.sid = sid
        self.events_classes = events_classes

    def filter(self, events, events_sids=None):
        """
        :param events: list объекты событий (не строки лога!)
        :return: список отфильтрованных событий
        """
        if events_sids is None:
            events_sids = {}

        results = []
        for event in events:
            for event_class in self.events_classes:
                if ((event_class == event.__class__) and
                        (events_sids.get(event) is None or self.sid in events_sids[event])):
                    results.append(event)
        return results
