# -*- coding: utf-8 -*-
from passport.backend.library.historydbloader.historydb.parser import ParserType
from passport.backend.logbroker_client.core.events.events import UserEvent


class UploadAvatarEvent(UserEvent):
    NAME = 'upload_by_url'

    PARSER_TYPE = ParserType.AVATARS

    @classmethod
    def is_this_event(cls, parser_type, event):
        if (parser_type == cls.PARSER_TYPE) and event.get('mode') == 'upload_by_url' and event.get('user_ip'):
            return cls(
                uid=event.get('uid'),
                avatar_to_upload=event.get('avatar_to_upload'),
                timestamp=event.get('unixtime'),
                user_ip=event.get('user_ip'),
                skip_if_set=event.get('skip_if_set', '0') == '1',
            )

    def __init__(self, uid, timestamp, avatar_to_upload, user_ip, skip_if_set):
        super(UploadAvatarEvent, self).__init__(self.NAME, uid, timestamp)
        self.avatar_to_upload = avatar_to_upload
        self.user_ip = user_ip
        self.skip_if_set = skip_if_set
