# -*- coding: utf-8 -*-
from passport.backend.api.settings.am_pushes import (
    AM_CAPABILITIES_BY_VERSION_ANDROID,
    AM_CAPABILITIES_BY_VERSION_IOS,
    AM_SUBSCRIPTION_APP_RULES,
)
from passport.backend.logbroker_client.core.run import run_app
import yenv


def main():
    run_app(
        configs=[
            'base.yaml',
            'challenge-pushes/base.yaml',
            'challenge-pushes/%s.yaml' % yenv.type,
            'logging_native.yaml',
            'challenge-pushes/logging.yaml',
            'export.yaml',
            'challenge-pushes/export.yaml',
        ],
        with_passport_settings=True,
        extra_exported_configs=dict(
            AM_CAPABILITIES_BY_VERSION_ANDROID=AM_CAPABILITIES_BY_VERSION_ANDROID,
            AM_CAPABILITIES_BY_VERSION_IOS=AM_CAPABILITIES_BY_VERSION_IOS,
            AM_SUBSCRIPTION_APP_RULES=AM_SUBSCRIPTION_APP_RULES,
        ),
    )
