# -*- coding: utf-8 -*-
import os

from passport.backend.library.historydbloader.historydb.parser import (
    get_parser,
    get_parser_type,
)
from six import StringIO


class BaseFilter(object):
    def filter(self, message):
        raise NotImplementedError()


class BasicFilter(BaseFilter):
    def __init__(self, events_classes):
        self.events_classes = events_classes

    def get_parser_types(self):
        parse_types_set = set()
        for event_class in self.events_classes:
            parse_types_set.add(event_class.PARSER_TYPE)
        return list(parse_types_set)

    def get_message_parser_type(self, message):
        logpath = message.file
        if not logpath:
            return
        logfilename = os.path.basename(logpath)
        return get_parser_type(logfilename)

    def filter(self, message):
        parser_types = self.get_parser_types()
        result = []

        parser_type = self.get_message_parser_type(message)
        if parser_type not in parser_types:
            return []

        parser = get_parser(parser_type)
        log_string_io = StringIO(message.data)
        log_events = parser.parse(log_string_io)
        for event in log_events:
            for event_class in self.events_classes:
                filtered_event = event_class.is_this_event(parser_type, event)
                if filtered_event:
                    result.append(filtered_event)
                    break
        return result
